# pragma GCC optimize("O3","unroll-loops")
# include <iostream>
# include <vector>
# include <algorithm>
# include <tuple>
# define all(x) x.begin(),x.end()
using namespace std;

const int MAX=5e6+11;

int N;
string s;

int occ[MAX];
int equiv[MAX];

void radix_sort(vector<pair<pair<int,int>,int>>& arr, int type)
{
    vector<pair<pair<int,int>,int>> new_arr(N);
    for(int i=0;i<N;i++) occ[i]=0;
    for(pair<pair<int,int>,int> pa: arr)
    {
        int x;
        if(type==1) x=pa.first.second;
        else x=pa.first.first;
        occ[x]++;
    }
    int sum=0;
    for(int i=0;i<N;i++)
    {
        sum+=occ[i];
        occ[i]=sum-occ[i];
    }
    for(pair<pair<int,int>,int> pa: arr)
    {
        int x;
        if(type==1) x=pa.first.second;
        else x=pa.first.first;

        new_arr[occ[x]]=pa;
        occ[x]++;
    }

    arr=new_arr;
}

int order[MAX];
int Rank[MAX];

void suffix_array()
{
    s.push_back('$');
    N=s.size();

    vector<pair<pair<int,int>,int>> suffs;
    for(int i=0;i<N;i++) suffs.push_back({{s[i],s[i]},i});
    sort(suffs.begin(),suffs.end());
    for(int i=1;i<N;i++)
    {
        int id=suffs[i].second,prv_id=suffs[i-1].second;
        equiv[id]=equiv[prv_id];
        if(suffs[i].first>suffs[i-1].first) equiv[id]++;
    }

    for(int bit=1;bit<N;bit*=2)
    {
        //cout<<bit<<":";
        //for(int i=0;i<n;i++) cout<<suffs[i].second<<" ";
        //cout<<"\n";

        for(int i=0;i<N;i++)
        {
            int id=suffs[i].second;
            suffs[i].first={equiv[id],equiv[(id+bit)%N]};
        }

        sort(suffs.begin(),suffs.end());
        //radix_sort(suffs,1);
        //radix_sort(suffs,0);

        for(int i=1;i<N;i++)
        {
            int id=suffs[i].second,prv_id=suffs[i-1].second;
            equiv[id]=equiv[prv_id];
            if(suffs[i].first>suffs[i-1].first) equiv[id]++;
        }
    }

    N--;
    for(int i=1;i<=N;i++)
    {
        order[i]=suffs[i].second;
        Rank[suffs[i].second]=i;
    }
}

pair<int,int> find_pattern(string& t)
{
    int sz=t.size();
    int l=1,r=N,ansL=-1;
    while(l<=r)
    {
        int mid=(l+r)/2;
        int pos=order[mid];

        bool f=1;
        int bp=-1;
        for(int i=pos;i<pos+sz;i++)
        {
            if(s[i]!=t[i-pos])
            {
                f=0;
                bp=i-pos;
                break;
            }
        }

        if(f)
        {
            ansL=mid;
            r=mid-1;
        }
        else
        {
            if(s[pos+bp]>t[bp]) r=mid-1;
            else l=mid+1;
        }
    }

    if(ansL==-1)
    {
        return {-1,-1};
    }

    l=1,r=N;
    int ansR=-1;
    while(l<=r)
    {
        int mid=(l+r)/2;
        int pos=order[mid];

        bool f=1;
        int bp=-1;
        for(int i=pos;i<pos+sz;i++)
        {
            if(s[i]!=t[i-pos])
            {
                f=0;
                bp=i-pos;
                break;
            }
        }

        if(f)
        {
            ansR=mid;
            l=mid+1;
        }
        else
        {
            if(s[pos+bp]>t[bp]) r=mid-1;
            else l=mid+1;
        }
    }

    //cout<<ansR-ansL+1<<"\n";
    return {ansL,ansR};
}

int n,q;
vector<int> positions[MAX];

int Count(int sz, int l, int r)
{
    return upper_bound(all(positions[sz]),r)-lower_bound(all(positions[sz]),l);
}

int main()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);cout.tie(0);

    cin>>n>>q;
    int mxSz=0;
    for(int i=1;i<=n;i++)
    {
        int sz;
        string word;
        cin>>word;
        sz=word.size();
        mxSz=max(mxSz,sz);

        int cnt=0;
        s+=word;
        for(int j=s.size()-1;j>=(int)s.size()-1-sz+1;j--)
        {
            cnt++;
            positions[cnt].push_back(j);
        }
        s+=word;
        s.push_back('#');
    }
    suffix_array();

    //cout<<s<<"\n";

    for(int i=1;i<=mxSz;i++)
    {
        for(int j=0;j<(int)positions[i].size();j++) positions[i][j]=Rank[positions[i][j]];
        sort(all(positions[i]));
    }

    while(q--)
    {
        string pref,suf,U;
        cin>>pref>>suf;
        U=suf+pref;
        int l,r;
        tie(l,r)=find_pattern(U);
        if(l==-1) cout<<0<<"\n";
        else cout<<Count(suf.size(),l,r)<<"\n";
    }

    return 0;
}

