# include <iostream>
# include <vector>
using namespace std;

const int MAX=2e5+11,LOG=20;

long long n,T;
long long c[MAX];
vector<int> adj[MAX];

int h[MAX];
long long up[MAX][LOG];
long long upw[MAX][LOG];

void dfs_init(int curr, int par)
{
    for(int nxt: adj[curr])
    {
        if(nxt==par) continue;
        h[nxt]=h[curr]+1;
        dfs_init(nxt,curr);
    }
}

void sparse_table()
{
    dfs_init(1,0);
    for(int j=1;j<LOG;j++)
    {
        for(int i=1;i<=n;i++)
        {
            if(h[i]-(1<<j)<0) continue;

            up[i][j]=up[up[i][j-1]][j-1];
            upw[i][j]=upw[i][j-1]+upw[up[i][j-1]][j-1];
        }
    }
}

long long delta[MAX];

void lift(int curr)
{
    int ori=curr;
    long long w=T;
    int cnt=0;
    for(int j=LOG-1;j>=0;j--)
    {
        if(h[curr]-(1<<j)>=0 and upw[curr][j]<=w)
        {
            cnt+=(1<<j);
            w-=upw[curr][j];
            curr=up[curr][j];
        }
    }

    //cout<<ori<<"->"<<curr<<" "<<c[ori]<<"\n";
    delta[ori]+=c[ori];
    delta[up[curr][0]]-=c[ori];
}

void dfs(int curr, int par)
{
    for(int nxt: adj[curr])
    {
        dfs(nxt,curr);
        delta[curr]+=delta[nxt];
    }
}

int main()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);cout.tie(0);

    cin>>n>>T;
    for(int i=2;i<=n;i++)
    {
        int par;
        cin>>par;
        adj[par].push_back(i);
        up[i][0]=par;
    }
    for(int i=2;i<=n;i++)
    {
        int w;
        cin>>w;
        upw[i][0]=w;
    }
    for(int i=1;i<=n;i++)
    {
        cin>>c[i];
        c[i]++;
    }

    sparse_table();
    for(int i=1;i<=n;i++) lift(i);
    dfs(1,0);

    long long ans=0;
    for(int i=1;i<=n;i++)
    {
        ans=max(ans,delta[i]);
        //cout<<i<<":"<<delta[i]<<"\n";
    }
    cout<<ans<<"\n";

    return 0;
}

