#include<bits/stdc++.h>
#include<ext/pb_ds/assoc_container.hpp>
#include<ext/pb_ds/tree_policy.hpp>
using namespace __gnu_pbds;
using namespace std;

using ordered_set = tree<pair <int, int>,null_type,less<pair <int, int>>,rb_tree_tag,tree_order_statistics_node_update>;

const int MAXN = 1e5 + 10;
ordered_set segment[4 * MAXN], segment2[4 * MAXN];
int previous[MAXN], previous2[MAXN], n;
set <int> pos[MAXN];

int cnt = 0;

void build(int idx, int l, int r) {
    if (l == r) {
        segment[idx].insert({previous[l], ++cnt});
        return;
    }

    int m = (l + r) / 2;

    build(2 * idx, l, m);
    build(2 * idx + 1, m + 1, r);

    for (auto x : segment[2 * idx]) {
        segment[idx].insert(x);
    }

    for (auto x : segment[2 * idx + 1]) {
        segment[idx].insert(x);
    }
}

void build2(int idx, int l, int r) {
    if (l == r) {
        segment2[idx].insert({previous2[l], ++cnt});
        return;
    }

    int m = (l + r) / 2;

    build2(2 * idx, l, m);
    build2(2 * idx + 1, m + 1, r);

    for (auto x : segment2[2 * idx]) {
        segment2[idx].insert(x);
    }

    for (auto x : segment2[2 * idx + 1]) {
        segment2[idx].insert(x);
    }
}

int query(int idx, int l, int r, int ql, int qr, int x) {
    if (qr < l || r < ql) return 0;
    if (ql <= l && r <= qr) return segment[idx].order_of_key({x, 0});

    int m = (l + r) / 2;
    return query(2 * idx, l, m, ql, qr, x) + query(2 * idx + 1, m + 1, r, ql, qr, x);
}

int query2(int idx, int l, int r, int ql, int qr, int x) {
    if (qr < l || r < ql) return 0;
    if (ql <= l && r <= qr) return segment2[idx].order_of_key({x, 0});

    int m = (l + r) / 2;
    return query2(2 * idx, l, m, ql, qr, x) + query2(2 * idx + 1, m + 1, r, ql, qr, x);
}

void add(int idx, int l, int r, int pos, int x) {
    if (l > r) return;
    if (pos < l || r < pos) return;

    segment[idx].insert({x, ++cnt});
    if (l == r) return;
    int m = (l + r) / 2;

    //assert(segment[idx].size() == r - l + 1);
    //cout << "CHANGED ADD " << idx << ' ' << l << ' ' << r << '\n';

    add(2 * idx, l, m, pos, x);
    add(2 * idx + 1, m + 1, r, pos, x);
}

void rem(int idx, int l, int r, int pos, int x) {
    if (l > r) return;
    if (pos < l || r < pos) return;

    //cout << "DEBUG " << segment[idx].size() << endl;
    //cout << x << endl;
    //for (auto p : segment[idx]) cout << "(" << p.first << ", " << p.second << ")" << ' ';
    //cout << '\n';
    segment[idx].erase(segment[idx].lower_bound({x, 0}));
    //cout << "DEBUG " << segment[idx].size() << endl;
    //for (auto p : segment[idx]) cout << "(" << p.first << ", " << p.second << ")" << ' ';
    //cout << '\n';

    //cout << "CHANGED REMOVE " << idx << ' ' << l << ' ' << r << '\n';


    if (l == r) return;
    int m = (l + r) / 2;

    rem(2 * idx, l, m, pos, x);
    rem(2 * idx + 1, m + 1, r, pos, x);
}

void add2(int idx, int l, int r, int pos, int x) {
    if (l > r) return;
    if (pos < l || r < pos) return;

    segment2[idx].insert({x, ++cnt});
    if (l == r) return;
    int m = (l + r) / 2;

    //assert(segment2[idx].size() == r - l + 1);
    //cout << "CHANGED " << idx << ' ' << l << ' ' << r << '\n';

    add2(2 * idx, l, m, pos, x);
    add2(2 * idx + 1, m + 1, r, pos, x);
}

void rem2(int idx, int l, int r, int pos, int x) {
    if (l > r) return;
    if (pos < l || r < pos) return;

    segment2[idx].erase(segment2[idx].lower_bound({x, 0}));
    if (l == r) return;
    int m = (l + r) / 2;

    rem2(2 * idx, l, m, pos, x);
    rem2(2 * idx + 1, m + 1, r, pos, x);
}

void upd(int idx, int val) {
    rem(1, 0, n - 1, idx, previous[idx]);
    previous[idx] = val;
    add(1, 0, n - 1, idx, previous[idx]);
}

void upd2(int idx, int val) {
    rem2(1, 0, n - 1, idx, previous2[idx]);
    previous2[idx] = val;
    add2(1, 0, n - 1, idx, previous2[idx]);
}

int a[MAXN];

void init(std::vector <int> a) {
    ::n = a.size();

    for (int i = 0; i < n; i++) {
        ::a[i] = a[i];
        if (pos[a[i]].size()) previous[i] = *(pos[a[i]].rbegin());
        else previous[i] = -1;

        if (previous[i] == -1) previous2[i] = -1;
        else previous2[i] = previous[previous[i]];

        pos[a[i]].insert(i);
    }

    build(1, 0, n - 1);
    build2(1, 0, n - 1);
}

std::vector <int> queries (std::vector <std::pair <int, int>> S) {
    vector <int> ans;

    for (auto [l, r] : S) {
        int a = query(1, 0, n - 1, l, r, l);
        int b = query2(1, 0, n - 1, l, r, l);

        ans.push_back(2 * a - b);
    }

    return ans;
}

void update(int idx, int val) {
    auto it = pos[a[idx]].find(idx);

    if (next(it) != pos[a[idx]].end()) {
        if (it != pos[a[idx]].begin()) upd(*next(it), *prev(it));
        else upd(*next(it), -1);

        if (it != pos[a[idx]].begin() && prev(it) != pos[a[idx]].begin()) upd2(*next(it), *prev(prev(it)));
        else upd2(*next(it), -1);

        if (next(next(it)) != pos[a[idx]].end()) {
            if (it != pos[a[idx]].begin()) upd2(*next(next(it)), *prev(it));
            else upd2(*next(next(it)), -1);
        }
    }

    pos[a[idx]].erase(it);
    a[idx] = val;

    pos[a[idx]].insert(idx);

    it = pos[a[idx]].find(idx);

    if (it != pos[a[idx]].begin()) upd(idx, *prev(it));
    else upd(idx, -1);

    if (it != pos[a[idx]].begin() && prev(it) != pos[a[idx]].begin()) upd2(idx, *prev(prev(it)));
    else upd2(idx, -1);

    if (next(it) != pos[a[idx]].end()) {
        upd(*next(it), idx);
        if (it != pos[a[idx]].begin()) upd2(*next(it), *prev(it));
        else upd2(*next(it), -1);

        if (next(next(it)) != pos[a[idx]].end()) upd2(*next(next(it)), idx);
    }

    /**for (int i = 0; i < n; i++) {
        cout << a[i] << ' ';
    }

    cout << '\n';

    for (int i = 0; i < n; i++) {
        cout << previous[i] << ' ';
    }

    cout << '\n';

    for (int i = 0; i < n; i++) {
        cout << previous2[i] << ' ';
    }

    cout << '\n';*/


}

