#include<bits/stdc++.h>
#include<ext/pb_ds/assoc_container.hpp>
#include<ext/pb_ds/tree_policy.hpp>
using namespace __gnu_pbds;
using namespace std;

using ordered_set = tree<int,null_type,less_equal<int>,rb_tree_tag,tree_order_statistics_node_update>;

const int MAXN = 1e5 + 10;
ordered_set segment[4 * MAXN], segment2[4 * MAXN];
int previous[MAXN], previous2[MAXN], n;
vector <int> pos[MAXN];

void build(int idx, int l, int r) {
    if (l == r) {
        segment[idx].insert(previous[l]);
        return;
    }

    int m = (l + r) / 2;

    build(2 * idx, l, m);
    build(2 * idx + 1, m + 1, r);

    for (int x : segment[2 * idx]) {
        segment[idx].insert(x);
    }

    for (int x : segment[2 * idx + 1]) {
        segment[idx].insert(x);
    }
}

void build2(int idx, int l, int r) {
    if (l == r) {
        segment2[idx].insert(previous2[l]);
        return;
    }

    int m = (l + r) / 2;

    build2(2 * idx, l, m);
    build2(2 * idx + 1, m + 1, r);

    for (int x : segment2[2 * idx]) {
        segment2[idx].insert(x);
    }

    for (int x : segment2[2 * idx + 1]) {
        segment2[idx].insert(x);
    }
}

int query(int idx, int l, int r, int ql, int qr, int x) {
    if (qr < l || r < ql) return 0;
    if (ql <= l && r <= qr) return segment[idx].order_of_key(x);

    int m = (l + r) / 2;
    return query(2 * idx, l, m, ql, qr, x) + query(2 * idx + 1, m + 1, r, ql, qr, x);
}

int query2(int idx, int l, int r, int ql, int qr, int x) {
    if (qr < l || r < ql) return 0;
    if (ql <= l && r <= qr) return segment2[idx].order_of_key(x);

    int m = (l + r) / 2;
    return query2(2 * idx, l, m, ql, qr, x) + query2(2 * idx + 1, m + 1, r, ql, qr, x);
}

void init(std::vector <int> a) {
    ::n = a.size();

    for (int i = 0; i < n; i++) {
        if (pos[a[i]].size()) previous[i] = pos[a[i]].back();
        else previous[i] = -1;

        if (previous[i] == -1) previous2[i] = -1;
        else previous2[i] = previous[previous[i]];

        pos[a[i]].push_back(i);
    }

    build(1, 0, n - 1);
    build2(1, 0, n - 1);
}

std::vector <int> queries (std::vector <std::pair <int, int>> S) {
    vector <int> ans;

    for (auto [l, r] : S) {
        int a = query(1, 0, n - 1, l, r, l);
        int b = query2(1, 0, n - 1, l, r, l);

        ans.push_back(2 * a - b);
    }

    return ans;
}

void update(int I, int V) {}

