#include <bits/stdc++.h>

#define maxn 200005
#define maxlog 21
#define endl '\n'
#define X first
#define Y second
#define PB push_back

typedef long long ll;
typedef std::pair <int , int> pii;



using namespace std;


struct segment_tree
{
    std::vector <ll> tree , lazy;
    ll sz;

    segment_tree()
    {
        sz = 0;
    }

    void init(ll s)
    {
        sz = s;
        tree.assign(s * 4 , 0);
        lazy.assign(s * 4 , 0);
    }

    segment_tree(ll r)
    {
        init(r);
    }


    void update(ll node , ll l , ll r , ll qp , ll qval)
    {
        if(l == r)
        {
            tree[node] = qval;
            return;;
        }

        int mid = (l + r) / 2;

        if(qp <= mid)
            update(node * 2 , l , mid , qp , qval);
        else
            update(node * 2 + 1 , mid + 1 , r , qp , qval);

        tree[node] = tree[node * 2] + tree[node * 2 + 1];
    }

    ll query(ll node , ll l , ll r , ll ql , ll qr)
    {
        if(l >= ql && r <= qr)
            return tree[node];
        if(l > qr || r < ql)
            return 0;

        int mid = (l + r) / 2;

        return query(node * 2 , l , mid , ql , qr) +
                query(node * 2 + 1 , mid + 1 , r , ql , qr);
    }
};




int a[maxn];
int n;
segment_tree tree;

void init(std::vector <int> aa)
{
    n = aa.size();
    tree.init(n * 2);
    for(int i = 0; i < aa.size(); i++)
        a[i] = aa[i];
}

void update(int I , int V)
{
    a[I] = V;
}



int br[maxn];
int pos[maxn];


std::vector <int> queries(std::vector <pii> s)
{
    for(int i = 0; i <= n; i++)
        pos[i] = -1;
    int qbr = s.size();
    std::vector <std::pair <pii , int> > qq;
    for(int i = 0; i < qbr; i++)
    {
        qq.PB({{s[i].Y , s[i].X} , i});
    }
    std::sort(qq.begin() , qq.end());

    std::vector <int> ret(qbr);
    int curr = -1;
    for(auto& e : qq)
    {
        int r = e.X.X;
        int l = e.X.Y;

        int idx = e.Y;

        while(curr < r)
        {
            curr++;
            int val = a[curr];
            if(pos[val] != -1)
            {
                tree.update(1 , 0 , n , pos[val] , -1);
            }
            tree.update(1 , 0 , n , curr , 1);
            pos[val] = curr;
        }

        ret[idx] = tree.query(1 , 0 , n , l , r);
    }

    return ret;
}




