#include <bits/stdc++.h>

#define maxn 200005
#define maxlog 21
#define endl '\n'
#define X first
#define Y second
#define PB push_back

typedef long long ll;
typedef std::pair <ll, ll> pll;



using namespace std;


std::map <int, int> tree[maxn * 4];
int n;
int q;


std::vector <int> suf[maxn];
std::string s[maxn];

void build(int node, int l, int r)
{
    if(l == r)
    {
        for(auto& e : suf[l])
            tree[node][e]++;

        return;
    }

    int mid = (l + r) / 2;

    build(node * 2, l, mid);
    build(node * 2 + 1, mid + 1, r);

    tree[node] = tree[node * 2 + 1];
    for(auto& e : tree[node * 2])
        tree[node][e.X] += e.Y;

}



ll query(int node , int l , int r , int ql , int qr , int qx)
{
    if(l > qr || r < ql)
        return 0;

    if(l >= ql && r <= qr)
        return tree[node][qx];

    int mid = (l + r) / 2;


    return query(node * 2 , l , mid , ql , qr , qx) +
            query(node * 2 + 1 , mid + 1 , r , ql , qr , qx);
}


const ll mod = 1e9 + 7;
const ll base = 67;
const int alpha = 27;

std::vector <int> pos[maxn][alpha];

void read()
{
    std::cin >> n >> q;

    for(int i = 0; i < n; i++)
        std::cin >> s[i];

    for(int i = 0; i < n; i++)
    {
        for(int j = 0; j < s[i].size(); j++)
            s[i][j] -= 'A';
    }

    for(int i = 0; i < n; i++)
    {
        suf[i].resize(s[i].size());

        ll hh = 0;
        for(int j = s[i].size() - 1; j >= 0; j--)
        {
            hh = (hh * base) % mod + s[i][j];
            if(hh >= mod)
                hh -= mod;

            suf[i][j] = hh;
        }
    }

    build(1 , 0 , n);

    for(int i = 0; i < n; i++)
    {
        for(int j = 0; j < s[i].size(); j++)
            pos[j][s[i][j]].PB(i);
    }

    std::sort(s , s + n);

    /**std::cout << "-----------------" << "\n";
    for(int i = 0; i < n; i++)
    {
        for(int j = 0 ;j < s[i].size(); j++)
            std::cout << s[i][j];
        std::cout << "\n";
    }*/

    while(q--)
    {
        int l = 0 , r = n - 1;

        std::string beg , en;
        std::cin >> beg >> en;

        bool lamp = true;

        for(int i = 0; i < beg.size(); i++)
        {
            /// pos[i][beg[i]] >= l , =< r

            


            if(pos[i][beg[i]].size() == 0 || pos[i][beg[i]].back() < l || pos[i][beg[i]][0] > r)
            {
                lamp = false;
                break;
            }


            l = std::upper_bound(pos[i][beg[i]].begin() , pos[i][beg[i]].end() , l) - pos[i][beg[i]].begin();

            int _l = 0 , _r = pos[i][beg[i]].size() - 1;

            while(_l <= _r)
            {
                int mid = (_l + _r) / 2;
                if(pos[i][beg[i]][mid] <= r)
                    _l = mid + 1;
                else
                    _r = mid - 1;
            }

            _l--;
            r = _l;
        }

        if(lamp == false)
        {
            std::cout << 0 << "\n";
            continue;
        }

        ll hh = 0;
        for(int i = en.size() - 1; i >= 0; i--)
        {
            hh = (hh * base) % mod + en[i];
            if(hh >= mod)
                hh -= mod;
        }


        std::cout << query(1 , 0 , n , l , r , hh) << "\n";
    }
}





int main()
{
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(nullptr);


    read();



    return 0;
}
