#include <bits/stdc++.h>

#define maxn 200005
#define maxlog 21
#define endl '\n'
#define X first
#define Y second
#define PB push_back

typedef long long ll;
typedef std::pair <ll , ll> pll;



using namespace std;


ll n;
std::vector <pll> v[maxn];
pll lift[maxlog][maxn];
ll t;
ll par[maxn];
ll depth[maxn];
ll x[maxn];
ll sz[maxn];


void dfs(ll node)
{
    sz[node] = 1;
    lift[0][node] = {par[node] , x[node]};
    for(auto& nb : v[node])
    {
        if(nb.X == par[node])
            continue;

        depth[nb.X] = depth[node] + 1;
        dfs(nb.X);
        sz[node] += sz[nb.X];
    }
}


struct segment_tree
{
    std::vector <ll> tree , lazy;
    ll sz;

    segment_tree()
    {
        sz = 0;
    }

    void init(ll s)
    {
        sz = s;
        tree.assign(s * 4 , 0);
        lazy.assign(s * 4 , 0);
    }

    segment_tree(ll r)
    {
        init(r);
    }

    void push_lazy(ll node , ll l , ll r) /// check
    {
        tree[node] += lazy[node];
        if(l != r)
        {
            lazy[node * 2] += lazy[node];
            lazy[node * 2 + 1] += lazy[node];
        }

        lazy[node] = 0;
    }

    void update(ll node , ll l , ll r , ll ql , ll qr , ll qval)
    {
        push_lazy(node , l , r);
        if(l > qr || r < ql)
            return;

        if(l >= ql && r <= qr)
        {
            lazy[node] += qval;
            push_lazy(node , l , r);

            return;
        }

        ll mid = (l + r) / 2;

        update(node * 2 , l , mid , ql , qr , qval);
        update(node * 2 + 1 , mid + 1 , r , ql , qr , qval);

        tree[node] = tree[node * 2] + tree[node * 2 + 1];
    }

    ll get_val(ll node , ll l , ll r , ll qp)
    {
        push_lazy(node , l , r);

        if(l == r)
            return tree[node];

        ll mid = (l + r) / 2;

        if(qp <= mid)
            return get_val(node * 2 , l , mid , qp);
        else
            return get_val(node * 2 + 1 , mid + 1 , r , qp);
    }
};




ll chain[maxn];
std::vector <ll> bych[maxn];
ll num;
ll pos[maxn];
ll lead[maxn];

void decompose(ll node , ll le , ll ch)
{
    chain[node] = ch;
    pos[node] = bych[chain[node]].size();
    bych[chain[node]].PB(node);
    lead[node] = le;

    ll masz = -1 , cc = -1;
    for(auto& nb : v[node])
    {
        if(nb.X == par[node])
            continue;

        if(sz[nb.X] > masz)
        {
            masz = sz[nb.X];
            cc = nb.X;
        }
    }

    if(cc == -1)
        return;

    decompose(cc , le , ch);
    for(auto& nb : v[node])
    {
        if(nb.X == cc || nb.X == par[node])
            continue;

        decompose(nb.X , nb.X , ++num);
    }
}

ll val[maxn];

segment_tree trees[maxn];

ll get_high(ll node)
{
    //std::cout << "??????????????????????" << "\n";
    //std::cout << node << "\n";
    ll ret = node;
    ll sum = 0;
    for(ll power = maxlog - 1; power >= 0; power--)
    {
        //std::cout << lift[power][node].X << " " << lift[power][node].Y << " " << sum << " " << t << "\n";
        if(lift[power][node].X != 0 && lift[power][node].Y + sum <= t)
        {
            sum += lift[power][node].Y;
            node = lift[power][node].X;
        }
    }


    return node;
}

void add(ll a , ll b)
{
    ll mudi = val[a] + 1;
    while(chain[a] != chain[b])
    {
        if(depth[lead[chain[a]]] < depth[lead[chain[b]]])
            std::swap(a , b);

        trees[chain[a]].update(1 , 0 , trees[chain[a]].sz , 0 , pos[a] , mudi);
        a = par[lead[a]];
    }

    if(pos[b] < pos[a])
        std::swap(a , b);
    trees[chain[a]].update(1 , 0 , trees[chain[a]].sz , pos[a] , pos[b] , mudi);
}


void read()
{
    num = 1;
    std::cin >> n >> t;

    for(ll i = 2; i <= n; i++)
        std::cin >> par[i];

    for(ll i = 2; i <= n; i++)
    {
        std::cin >> x[i];
        v[par[i]].PB({i , x[i]});
    }

    for(ll i = 1; i <= n; i++)
        std::cin >> val[i];

    dfs(1);
    lift[0][1].X = 0;
    for(ll power = 1; power < maxlog; power++)
    {
        for(ll i = 1; i <= n; i++)
        {
            lift[power][i] = {lift[power - 1][lift[power - 1][i].X].X , lift[power - 1][i].Y + lift[power - 1][lift[power - 1][i].X].Y};
        }
    }
    num = 1;
    decompose(1 , 1 , 1);

    /*for(ll i = 1; i <= num; i++)
    {
        std::cout << i << ": ";
        for(auto& e : bych[i])
            std::cout << e << " ";
        std::cout << "\n";
    }*/
    //std::cout << "-----------------------" << "\n";
    for(ll i = 1; i <= num; i++)
        trees[i].init(bych[i].size() + 5);

    for(ll i = 1; i <= n; i++)
    {
        ll up = get_high(i);

        //std::cout << i << ": " << up << "\n";
        add(i , up);
    }

    ll ans = 0;

    for(ll i = 1; i <= n; i++)
    {
        ans = std::max(ans , (ll)trees[chain[i]].get_val(1 , 0 , trees[chain[i]].sz , pos[i]));
    }

    std::cout << ans << "\n";
}





int main()
{
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(nullptr);


    read();



    return 0;
}
