#include<iostream>
#include<algorithm>
#include<signal.h>
#include<vector>
#include<random>
#include "manager.h"
using namespace std;
const int PROCESSES=1;
void finish_error (string error) {
    cout << error << endl ;
    exit(0);
}

int b,k,w;
vector <pair <int, int>> targets;
mt19937_64 rng;
int wave_cnt=0,probe_cnt=0;
void query () {
    wave_cnt++;
    if (wave_cnt>w) finish_error("wave_cnt_exceeded");

    int probes_size;
    if (!(in(0) >> probes_size)) finish_error("Interaction protocol violated");
    if (probe_cnt>20000) finish_error("probe_cnt_exceeded");

    vector<int> dists;
    dists.reserve(probes_size*targets.size());
    for (int i=0; i<probes_size; i++) {
        int x,y;
        if (!(in(0) >> x >> y)) finish_error("Interaction protocol violated");
        if ((x<-100000000)||(x>100000000)) finish_error("coord_out_of_range");
        if ((y<-100000000)||(y>100000000)) finish_error("coord_out_of_range");
        for (int j=0; j<targets.size(); j++) {
            int dx=abs(x-targets[j].first);
            int dy=abs(y-targets[j].second);
            dists.push_back(dx+dy);
        }
    }
    shuffle(dists.begin(),dists.end(),rng);
    for (auto d : dists) {
        out(0) << d << " ";
    }
    out(0) << endl ;
}

const long long int mod=5656577,base=263;
void calculate_hash (long long int& hash1, int value) {
    hash1*=base; hash1+=value;
    hash1%=mod;
}
int main (int argc, char* argv[]) {
    signal(SIGPIPE,SIG_IGN);
    fd_to_stream(argv+1,2*PROCESSES);
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    random_device rd;
    rng.seed(rd());

    long long int hash1=0;
    cin >> b >> k >> w;
    calculate_hash(hash1,b);
    calculate_hash(hash1,k);
    calculate_hash(hash1,w);

    targets.resize(k);
    for (int i=0; i<k; i++) {
        cin >> targets[i].first >> targets[i].second;
    }

    out(0) << b << " " << k << " " << w << endl ;
    for (;;) {
        long long int hash2;
        if (!(in(0) >> hash2)) finish_error("Interaction protocol violated");
        if (hash1!=hash2) finish_error("Interaction protocol violated");
        bool finish;
        if (!(in(0) >> finish)) finish_error("Interaction protocol violated");
        if (finish==true) break;
        query();
    }

    int res_size;
    if (!(in(0) >> res_size)) finish_error("Interaction protocol violated");
    if (res_size!=k) finish_error("targets_count_mismatch");
    vector <pair <int, int>> res(res_size);
    for (int i=0; i<res_size; i++) {
        if (!(in(0) >> res[i].first >> res[i].second)) finish_error("Interaction protocol violated");
    }

    cout << "grader_ok" << endl;
    for (int i=0; i<res_size; i++) {
        cout << res[i].first << " " << res[i].second << "\n";
    }
    return 0;
}
