#include "drone.h"
#include <iostream>
#include <fstream>
#include <vector>
#include <random>
#include <algorithm>

static int b, k, w;
static std::vector<std::pair<int, int>> targets;
static std::mt19937 rng;

static int wave_cnt = 0, probe_cnt = 0;

std::vector<int> query(std::vector<std::pair<int, int>> probes)
{
    wave_cnt++;
    probe_cnt += probes.size();

    if (wave_cnt > w)
    {
        std::cout << "wave cnt exceeded" << std::endl;
        exit(0);
    }
    if (probe_cnt > 20000)
    {
        std::cout << "probe cnt exceeded" << std::endl;
        exit(0);
    }

    std::vector<int> dists;
    dists.reserve(probes.size() * targets.size());

    for (int i = 0; i < probes.size(); ++ i)
    {
        if (probes[i].first < -100000000 or probes[i].first > 100000000
            or probes[i].second < -100000000 or probes[i].second > 100000000)
        {
            std::cout << "coord out of range" << std::endl;
            exit(0);
        }
        for (int j = 0; j < targets.size(); ++ j)
        {
            int dx = abs(probes[i].first - targets[j].first);
            int dy = abs(probes[i].second - targets[j].second);
            dists.push_back(dx + dy);
        }
    }

    std::shuffle(dists.begin(), dists.end(), rng);

    return dists;
}

int main()
{
    std::ios_base :: sync_with_stdio(false);
    std::cin.tie(NULL); std::cout.tie(NULL);

    std::random_device rd;
    rng.seed(rd());

    std::cin >> b >> k >> w;
    targets.resize(k);
    for (int i = 0; i < k; ++ i)
    {
        std::cin >> targets[i].first >> targets[i].second;
    }

    auto targets = solve(b, k, w);
    if (targets.size() != k)
    {
        std::cout << "targets count mismatch" << std::endl;
        exit(0);
    }

    std::cout << "grader ok" << std::endl;
    for (int i = 0; i < targets.size(); ++ i)
    {
        std::cout << targets[i].first << ' ' << targets[i].second << '\n';
    }

    return 0;
}
