#include <iostream>
#include <fstream>
#include <algorithm>
#include <vector>
using namespace std;

const int BASE = 263, MOD = 5656577;

ifstream inp, out;

int b, k, w;
vector<pair<int, int>> targets, out_targets;

int main(int argc, char *argv[])
{
    inp.open(argv[1]);
    out.open(argv[3]);

    string grader_message;
    out >> grader_message;

    if (grader_message == "wave_cnt_exceeded")
    {
        cout << 0 << endl;
        cerr << "Number of waves exceeded" << endl;
        return 0;
    }

    if (grader_message == "probe_cnt_exceeded")
    {
        cout << 0 << endl;
        cerr << "Number of probes exceeded" << endl;
        return 0;
    }

    if (grader_message == "coord_out_of_range")
    {
        cout << 0 << endl;
        cerr << "Probe coordinates out of range" << endl;
        return 0;
    }

    if (grader_message == "targets_count_mismatch")
    {
        cout << 0 << endl;
        cerr << "Submitted targets are not exactly k" << endl;
        return 0;
    }

    if (grader_message != "grader_ok")
    {
        cout << 0 << endl;
        cerr << "Interaction protocol violated" << endl;
        return 0;
    }

    inp >> b >> k >> w;

    targets.resize(k);
    for (int i = 0; i < k; ++ i)
    {
        inp >> targets[i].first >> targets[i].second;
    }
    inp.close();

    out_targets.resize(k);
    for (int i = 0; i < k; ++ i)
    {
        out >> out_targets[i].first >> out_targets[i].second;
        if (!out.good())
        {
            cout << 0 << endl;
            cerr << "Interaction protocol violated" << endl;
            return 0;
        }
    }

    sort(targets.begin(), targets.end());
    sort(out_targets.begin(), out_targets.end());

    if (targets == out_targets)
    {
        cout << 1 << endl;
        cerr << "Correct answer" << endl;
    }
    else
    {
        cout << 0 << endl;
        cerr << "Wrong answer" << endl;
    }

    out.close();
    return 0;
}
