#include<bits/stdc++.h>
#define MAXN 100007
#define MAXS 2000007
using namespace std;

struct event{
    int l,r,id;
};

struct node{
    vector<int> words;
    int ch[4];
};

int n,m;
string word[MAXN],s,t;

node prefix[MAXS],suffix[MAXS];
int pr,sf;

void transform(string &s){
    for(int f=0;f<s.size();f++){
        if(s[f]=='G')s[f]='B';
        if(s[f]=='U')s[f]='D';
    }
}

void add(string s,int id){
    int curr=0;
    for(int i=0;i<s.size();i++){
        if(prefix[curr].ch[s[i]-'A']==0){
            pr++; prefix[curr].ch[s[i]-'A']=pr;
        }

        curr=prefix[curr].ch[s[i]-'A'];
    }

    prefix[curr].words.push_back(id);

    reverse(s.begin(),s.end());

    curr=0;
    for(int i=0;i<s.size();i++){
        if(suffix[curr].ch[s[i]-'A']==0){
            sf++; suffix[curr].ch[s[i]-'A']=sf;
        }

        curr=suffix[curr].ch[s[i]-'A'];
    }

    suffix[curr].words.push_back(id);
}

int num,in[MAXN],ans[MAXN];
int euler[MAXN],pos;

int mins[MAXS],maxs[MAXS];
int from[MAXS],to[MAXS];

void dfs(int x){
    mins[x]=num+1;

    for(int i:prefix[x].words){
        num++; in[i]=num;
    }

    for(int i=0;i<4;i++){
        if(prefix[x].ch[i]!=0)dfs(prefix[x].ch[i]);
    }

    maxs[x]=num;
}

void dfs2(int x){
    from[x]=pos+1;

    for(int i:suffix[x].words){
        pos++; euler[pos]=in[i];
    }

    for(int i=0;i<4;i++){
        if(suffix[x].ch[i]!=0)dfs2(suffix[x].ch[i]);
    }

    to[x]=pos;
}


int findpref(string s){
    int curr=0;
    for(int i=0;i<s.size();i++){
        if(prefix[curr].ch[s[i]-'A']==0)return -1;
        curr=prefix[curr].ch[s[i]-'A'];
    }
    
    return curr;
}

int findsuff(string s){
    reverse(s.begin(),s.end());

    int curr=0;
    for(int i=0;i<s.size();i++){
        if(suffix[curr].ch[s[i]-'A']==0)return -1;
        curr=suffix[curr].ch[s[i]-'A'];
    }

    return curr;
}

vector<event> query[MAXS];

int fenwick[MAXN];

void update(int x){
    while(x<=n){
        fenwick[x]++;
        x+=(x & (-x));
    }
}

int getsum(int x){
    int res=0;

    while(x>=1){
        res+=fenwick[x];
        x-=(x & (-x));
    }

    return res;
}

int main(){

    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);

    cin>>n>>m;
    for(int i=1;i<=n;i++){
        cin>>word[i];

        transform(word[i]);

        add(word[i],i);
    }

    dfs(0);
    dfs2(0);

    for(int i=1;i<=m;i++){
        cin>>s>>t;

        transform(s);
        transform(t);

        int a=findpref(s);
        int b=findsuff(t);

        if(a==-1 or b==-1)continue;
        if(mins[a]>maxs[a] or from[b]>to[b])continue;

        query[from[b]-1].push_back({mins[a],maxs[a],-i});
        query[to[b]].push_back({mins[a],maxs[a],i});
    }

    for(int i=1;i<=pos;i++){
        update(euler[i]);

        for(event e:query[i]){
            if(e.id<0){
                ans[-e.id]-=getsum(e.r)-getsum(e.l-1);
            }else{
                ans[e.id]+=getsum(e.r)-getsum(e.l-1);
            }
        }
    }

    for(int i=1;i<=m;i++){
        cout<<ans[i]<<"\n";
    }

    return 0;
}