#include <bits/stdc++.h>
using namespace std;

int main() {
    int N, M;
    cin >> N >> M;

    vector<int> big(M);
    for(int i = 0; i < M; i++) cin >> big[i];

    int A, B;
    cin >> A >> B;

    vector<int> dist(N+1, INT_MAX);
    dist[A] = 0;

    // Сортираме големите спирки за удобство
    sort(big.begin(), big.end());

    // Минален приоритетен ред за Dijkstra
    priority_queue<pair<int,int>, vector<pair<int,int>>, greater<>> pq;
    pq.push({0, A});

    while(!pq.empty()) {
        auto [d, u] = pq.top(); pq.pop();
        if(d != dist[u]) continue;

        // Обикновен влак: съседни спирки
        if(u > 1 && dist[u-1] > dist[u]+1) {
            dist[u-1] = dist[u]+1;
            pq.push({dist[u-1], u-1});
        }
        if(u < N && dist[u+1] > dist[u]+1) {
            dist[u+1] = dist[u]+1;
            pq.push({dist[u+1], u+1});
        }

        // Експресен влак: само между големи спирки
        auto it = lower_bound(big.begin(), big.end(), u);
        if(it != big.end() && *it != u) {
            int v = *it;
            if(dist[v] > dist[u]+2) {
                dist[v] = dist[u]+2;
                pq.push({dist[v], v});
            }
        }
        if(it != big.begin()) {
            --it;
            int v = *it;
            if(dist[v] > dist[u]+2) {
                dist[v] = dist[u]+2;
                pq.push({dist[v], v});
            }
        }
    }

    cout << dist[B] << endl;
    return 0;
}
