#include <iostream>
#include <algorithm>
using namespace std;

int arr[10000];   // номера на големите спирки
int dp[10000];    // минимална цена до всяка голяма спирка

int main() {
    int n, m;
    cin >> n >> m; // брой спирки и брой големи спирки

    for (int i = 0; i < m; i++) {
        cin >> arr[i];
    }

    int A, B;
    cin >> A >> B;

    // dp[i] = минимална цена до голяма спирка arr[i]
    for (int i = 0; i < m; i++) dp[i] = 1e9;

    // стъпка 1: обикновен влак от A до всяка голяма спирка ≥ A
    for (int i = 0; i < m; i++) {
        if (arr[i] >= A) {
            dp[i] = arr[i] - A; // цена с обикновен влак
            break;
        }
    }

    // стъпка 2: динамично пресмятане на минимална цена за следващите големи спирки
    for (int i = 0; i < m; i++) {
        if (dp[i] == 1e9) continue; // недостъпна

        // обикновен влак до следващи големи спирки
        for (int j = i + 1; j < m; j++) {
            int cost = dp[i] + (arr[j] - arr[i]); // обикновен влак
            if (cost < dp[j]) dp[j] = cost;

            cost = dp[i] + 2; // експресен влак
            if (cost < dp[j]) dp[j] = cost;
        }
    }

    // стъпка 3: обикновен влак от последната голяма спирка ≤ B до B
    int answer = B - A; // по дефолт, ако няма големи спирки между A и B

    for (int i = 0; i < m; i++) {
        if (arr[i] <= B && dp[i] < 1e9) {
            int total = dp[i] + (B - arr[i]);
            if (total < answer) answer = total;
        }
    }

    cout << answer << endl;
    return 0;
}
