#include <iostream>
using namespace std;

int main() {
    int N, M;
    cin >> N >> M;

    int big[10000];       // номера на големите спирки
    bool is_big[10001];   // дали спирката е голяма
    for(int i = 1; i <= 10000; i++) is_big[i] = false;

    for(int i = 0; i < M; i++) {
        cin >> big[i];
        is_big[big[i]] = true;
    }

    int A, B;
    cin >> A >> B;

    int distO[10001]; // минимална цена с обикновен влак
    int distE[10001]; // минимална цена с експрес

    for(int i = 1; i <= N; i++) {
        distO[i] = 1000000; // голяма стойност
        distE[i] = 1000000;
    }

    distO[A] = 0;
    if(is_big[A]) distE[A] = 0;

    // обикновен влак: движение между съседни спирки
    for(int i = 1; i <= N; i++) {
        if(i > 1 && distO[i-1] + 1 < distO[i]) distO[i] = distO[i-1] + 1;
        if(i < N && distO[i+1] + 1 < distO[i]) distO[i+1] = distO[i] + 1;
    }

    // експрес: движение между големи спирки
    for(int i = 0; i < M; i++) {
        for(int j = i + 1; j < M; j++) {
            int cost = 2; // цена между две големи спирки
            if(distE[big[i]] + cost < distE[big[j]]) distE[big[j]] = distE[big[i]] + cost;
            if(distE[big[j]] + cost < distE[big[i]]) distE[big[i]] = distE[big[j]] + cost;
        }
    }

    // прекачване на големи спирки
    for(int i = 0; i < M; i++) {
        int s = big[i];
        if(distO[s] < distE[s]) distE[s] = distO[s];
        if(distE[s] < distO[s]) distO[s] = distE[s];
    }

    int ans = distO[B];
    if(distE[B] < ans) ans = distE[B];

    cout << ans << endl;
    return 0;
}