#include <iostream>
#include <vector>
#include <queue>
using namespace std;

struct Node {
    int pos;
    int type; // 0 = обикновен, 1 = експрес
};

int main() {
    int N, M;
    cin >> N >> M;
    vector<int> big(M);
    vector<bool> is_big(N+1, false);
    for(int i = 0; i < M; i++) {
        cin >> big[i];
        is_big[big[i]] = true;
    }

    int A, B;
    cin >> A >> B;

    const int INF = 1000000000;
    vector<vector<int>> dist(N+1, vector<int>(2, INF));

    queue<Node> q;

    dist[A][0] = 0; // старт с обикновен влак
    q.push({A,0});
    if(is_big[A]) {
        dist[A][1] = 0; // старт с експрес
        q.push({A,1});
    }

    while(!q.empty()) {
        Node cur = q.front(); q.pop();
        int u = cur.pos;
        int t = cur.type;
        int d = dist[u][t];

        if(t == 0) { // обикновен влак
            if(u > 1 && d+1 < dist[u-1][0]) { dist[u-1][0] = d+1; q.push({u-1,0}); }
            if(u < N && d+1 < dist[u+1][0]) { dist[u+1][0] = d+1; q.push({u+1,0}); }
        } else { // експресен влак
            for(int i=0;i<M;i++){
                if(big[i] < u && d+2 < dist[big[i]][1]) { dist[big[i]][1] = d+2; q.push({big[i],1}); }
                if(big[i] > u && d+2 < dist[big[i]][1]) { dist[big[i]][1] = d+2; q.push({big[i],1}); }
            }
        }

        // прекачване на голяма спирка
        if(is_big[u]) {
            int other = 1-t;
            if(d < dist[u][other]) { dist[u][other] = d; q.push({u,other}); }
        }
    }

    int ans = min(dist[B][0], dist[B][1]);
    cout << ans << endl;
    return 0;
}