// bruth force  -30 points
#include<bits/stdc++.h>
using namespace std;

const int inf = 1e9+7;

struct ST_min{
    int n;
    vector<int>data;
    ST_min(int n) : n(n){
        data = vector<int>(4*n + 4, inf);
    }
    int qry(int node, int l, int r, int ql, int qr){
        if(r < ql || qr < l)return inf;
        if(ql <= l && r <= qr)return data[node];
        int m = (l+r)/2;
        return min(qry(node*2 + 0, l + 0, m, ql, qr),
                   qry(node*2 + 1, m + 1, r, ql, qr));
    }
    void up(int node, int l, int r, int x, int v){
        if(l == r)data[node] = v;
        else{
            int m = (l + r)/2;
            if(l <= x && x <= m)up(node*2 + 0, l + 0, m, x, v);
            else                up(node*2 + 1, m + 1, r, x, v);
            data[node] = min(data[node * 2], data[node * 2 +1]);
        }
    }
    int qry(int l, int r){return qry(1, 1, n, l, r);}
    void up(int x, int v){up(1, 1, n, x, v);}
};
struct ST_max{
    int n;
    vector<int>data;
    ST_max(int n) : n(n){
        data = vector<int>(4*n + 4);
    }
    int qry(int node, int l, int r, int ql, int qr){
        if(r < ql || qr < l)return 0;
        if(ql <= l && r <= qr)return data[node];
        int m = (l+r)/2;
        return max(qry(node*2 + 0, l + 0, m, ql, qr),
                   qry(node*2 + 1, m + 1, r, ql, qr));
    }
    void up(int node, int l, int r, int x, int v){
        if(l == r)data[node] = v;
        else{
            int m = (l + r)/2;
            if(l <= x && x <= m)up(node*2 + 0, l + 0, m, x, v);
            else                up(node*2 + 1, m + 1, r, x, v);
            data[node] = max(data[node * 2], data[node * 2 +1]);
        }
    }
    int qry(int l, int r){return qry(1, 1, n, l, r);}
    void up(int x, int v){up(1, 1, n, x, v);}
};

int main(){
    ios_base::sync_with_stdio(false);
    cin.tie(0); cout.tie(0);
    int d1, d2; cin >> d1 >> d2;
    int n; cin >> n;
    ST_min R(n+1);
    ST_max L(n+1);
    for(int i = 1; i <= n; i++){
        int a, b; cin >> a >> b;
        L.up(i, a);
        R.up(i, b);
    }
    int ans = 0;
    for(int l = 1; l <= n; l++){
        for(int r = l; r <= n; r++){
            int _l = L.qry(l, r);
            int _r = R.qry(l, r);
            int len = max(_r - _l + 1, 0);
            if(d1 <= len && len <= d2)ans++;
        }
    }
    cout << ans << endl;
}
