#include <iostream>
#include <vector>
using namespace std;
const int MOD = 1e9 + 7;
int n, k;
vector<vector<int>> graph;
vector<vector<long long>> dp;
void dfs(int v) {
    dp[v][0] = 1;
    dp[v][1] = 0;
    vector<long long> ways(k);
    ways[0] = 1;
    for (int i : graph[v]) {
        dfs(i);
        dp[v][0] = dp[v][0] * (dp[i][0] + dp[i][1]) % MOD;
        vector<long long> newways(k);
        for (int j = 0; j < k; j++) {
            if (ways[j] == 0) {
                continue;
            }
            newways[j] = (newways[j] + ways[j] * (dp[i][0] + dp[i][1])) % MOD;
            if (j + 1 < k) {
                newways[j + 1] = (newways[j + 1] + ways[j] * dp[i][0]) % MOD;
            }
        }
        ways.swap(newways);
    }
    for (int j = 2; j < k; j++) {
        dp[v][1] = (dp[v][1] + ways[j]) % MOD;
    }
}
int main() {
    ios :: sync_with_stdio(false);
    cin.tie(nullptr);
    cin >> n >> k;
    graph.resize(n + 1);
    dp.resize(n + 1, vector<long long>(2));
    for (int i = 2; i <= n; i++) {
        int par;
        cin >> par;
        graph[par].push_back(i);
    }
    dfs(1);
    cout << (dp[1][0] + dp[1][1]) % MOD;
}