#include <iostream>
#include <vector>
#include <deque>
using namespace std;
struct interval {
    long long l, r;
};
long long n;
long long cnt(const vector<interval>& ab, long long d) {
    if (d == 0) {
        return n * (n + 1) / 2;
    }
    deque<long long> a, b;
    long long ans = 0;
    long long i = 0;
    for (long long j = 0; j < n; j++) {
        while (!a.empty() && ab[a.back()].l <= ab[j].l) {
            a.pop_back();
        }
        a.push_back(j);
        while (!b.empty() && ab[b.back()].r >= ab[j].r) {
            b.pop_back();
        }
        b.push_back(j);
        while (i <= j) {
            long long l = ab[a.front()].l;
            long long r = ab[b.front()].r;
            long long len = max(0LL, r - l + 1);
            if (len >= d) {
                break;
            }
            if (!a.empty() && a.front() == i) {
                a.pop_front();
            }
            if (!b.empty() && b.front() == i) {
                b.pop_front();
            }
            i++;
        }
        if (i <= j) {
            long long l = ab[a.front()].l;
            long long r = ab[b.front()].r;
            long long len = max(0LL, r - l + 1);
            if (len >= d) {
                ans += j - i + 1;
            }
        }
    }
    return ans;
}
int main() {
    ios :: sync_with_stdio(false);
    cin.tie(nullptr);
    long long d1, d2;
    cin >> d1 >> d2;
    cin >> n;
    vector<interval> ab(n);
    for (long long i = 0; i < n; i++) {
        cin >> ab[i].l >> ab[i].r;
    }
    cout << cnt(ab, d1) - cnt(ab, d2 + 1);
}