# include <bits/stdc++.h>
# define ll long long
using namespace std;

const int MAXN = 1e5 + 1;
int n, Time;
int p[MAXN];
int t[MAXN];
ll a[MAXN];

vector<int> graph[MAXN];
vector<int> order;

ll depth[MAXN];

vector<ll> encode;
unordered_map<ll, int> decode;

ll tree[2 * MAXN];

void update(int index, ll value)
{
    while(index < 2 * MAXN)
    {
        tree[index] += value;
        index += (index & (-index));
    }
}

ll query(int index)
{
    ll sum = 0;

    while(index > 0)
    {
        sum += tree[index];
        index -= (index & (-index));
    }

    return sum;
}

ll prefix[MAXN];
ll answer;

void dfs(int u)
{
    order.push_back(u);

    for(auto& v : graph[u])
    {
        depth[v] = depth[u] + t[v];
        dfs(v);
    }

    order.push_back(u);
}

void upgrade_speed()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
}


int main()
{
    upgrade_speed();
    cin >> n >> Time;

    for(int i = 2; i <= n; i++)
    {
        cin >> p[i];
        graph[p[i]].push_back(i);
    }

    for(int i = 2; i <= n; i++)
    {
        cin >> t[i];
    }

    for(int i = 1; i <= n; i++)
    {
        cin >> a[i];
        a[i]++;
    }

    dfs(1);

    for(int u = 1; u <= n; u++)
    {
        encode.push_back(depth[u]);
        encode.push_back(depth[u] + Time);
    }

    sort(encode.begin(), encode.end());

    ll previous = -1;
    int code = 0;

    for(auto& current : encode)
    {
        if(current != previous)
        {
            code++;
            decode[current] = code;
        }

        previous = current;
    }

    for(int u = 1; u <= n; u++)
    {
        prefix[u] = -1;
    }

    for(auto& u : order)
    {
        int left = decode[depth[u]];
        int right = decode[depth[u] + Time];

        if(prefix[u] == -1)
        {
            prefix[u] = query(right);
            update(left, a[u]);
        }
        else
        {
            update(left, a[u]);
            ll current = (query(right) - prefix[u]) / 2;
            answer = max(answer, current);
        }
    }

    cout << answer;
    return 0;
}
