#include <iostream>
#include <algorithm>
#include <cassert>
#include <vector>

#define int long long

const int MAXN = 100000 + 10;
const int INF = 1e9 + 10;

int n, t;
int res;

struct MST
{
    struct Element
    {
        int w;
        int p;
    };

    std::vector<Element> tree[4 * MAXN];
    std::vector<int> prefix[4 * MAXN];

    void build(int node, int l, int r, int arr1[], int arr2[])
    {
        tree[node].reserve(r - l + 1);
        prefix[node].reserve(r - l + 1);

        if(l == r)
        {
            tree[node].push_back({arr1[l], arr2[l]});
            prefix[node][0] = arr2[l];
            return;
        }

        int mid = l + r >> 1;
        build(2*node, l, mid, arr1, arr2);
        build(2*node + 1, mid + 1, r, arr1, arr2);

        int lPtr = 0, rPtr = 0;
        for(int i = 0 ; i < tree[2*node].size() + tree[2*node + 1].size() ; ++i)
        {
            if(lPtr == tree[2*node].size())
            {
                tree[node].push_back(tree[2*node + 1][rPtr++]);
                continue;
            }

            if(rPtr == tree[2*node + 1].size())
            {
                tree[node].push_back(tree[2*node][lPtr++]);
                continue;
            }

            if(tree[2*node][lPtr].w <= tree[2*node + 1][rPtr].w)
            {
                tree[node].push_back(tree[2*node][lPtr++]);
            }
            else
            {
                tree[node].push_back(tree[2*node+1][rPtr++]);
            }
        }

        prefix[node][0] = tree[node][0].p;
        for(int i = 1 ; i < tree[2*node].size() + tree[2*node + 1].size() ; ++i)
        {
            prefix[node][i] = prefix[node][i - 1] + tree[node][i].p;
        }

        /*std::cout << l << " " << r << "\n";
        for(int i = 0 ; i < tree[2*node].size() + tree[2*node + 1].size() ; ++i)
        {
            std::cout << tree[node][i].w << " ";
        }
        
        std::cout << "\n";

        for(int i = 0 ; i < tree[2*node].size() + tree[2*node + 1].size() ; ++i)
        {
            std::cout << prefix[node][i] << " ";
        }

        std::cout << "\n\n";*/
    }

    int binary(int node, int k)
    {
        int l = -1, r = tree[node].size();

        while(l + 1 < r)
        {
            int mid = l + r >> 1;

            if(tree[node][mid].w <= k) l = mid;
            else r = mid;
        }

        return prefix[node][l];
    }

    int query(int node, int l, int r, int queryL, int queryR, int queryVal)
    {
        if(queryL <= l && r <= queryR)
        {
            return binary(node, queryVal);
        }

        int res = 0;
        int mid = l + r >> 1;
        if(queryL <= mid) res += query(2*node, l, mid, queryL, queryR, queryVal);
        if(mid + 1 <= queryR) res += query(2*node + 1, mid + 1, r, queryL, queryR, queryVal);
        return res;
    }
};

int a[MAXN];
int b[MAXN];
int flatA[MAXN];
int flatB[MAXN];
int parent[MAXN];
std::vector<int> g[MAXN];
int pos;
int timer;
int in[MAXN];
int out[MAXN];
int tour[MAXN];
MST mst;

void euler(int node, int par, int lazy)
{
    in[node] = ++timer;
    tour[++pos] = node;
    a[node] += lazy;

    for(const int &to : g[node])
    {
        if(to == par) continue;
        euler(to, node, lazy + a[node]);
    }

    out[node] = timer;
}

void solve()
{
    euler(1, 0, 0);

    for(int i = 1 ; i <= n ; ++i)
    {
        flatA[in[i]] = a[i];
        flatB[in[i]] = b[i];
    }

    mst.build(1, 1, n, flatA, flatB);

    for(int i = 1 ; i <= n ; ++i)
    {
        res = std::max(res, mst.query(1, 1, n, in[i], out[i], t + a[i]));
    }
}

void input()
{
    std::cin >> n >> t;

    for(int i = 2 ; i <= n ; ++i)
    {
        std::cin >> parent[i];
        g[parent[i]].push_back(i);
        g[i].push_back(parent[i]);
    }

    for(int i = 2 ; i <= n ; ++i)
    {
        std::cin >> a[i];
    }
    
    for(int i = 1 ; i <= n ; ++i)
    {
        std::cin >> b[i];
        b[i] += 1;
    }
}

void output()
{
    std::cout << res << "\n";
}

void fastIO()
{
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL); 
    std::cout.tie(NULL);
}

signed main()
{
    fastIO();
    input();
    solve();
    output();
    return 0;
}