#include <iostream>
#include <algorithm>
#include <vector>

#define int long long

const int MAXN = 100000 + 10;
const int INF = 1e9 + 10;

int n, t;
int a[MAXN];
int b[MAXN];
int parent[MAXN];
std::vector<int> tree[MAXN];
int order[MAXN];
int prefixA[MAXN];
int suffixA[MAXN];
int prefixB[MAXN];
int suffixB[MAXN];
int pos;
int res;

void dfs(int node, int par)
{
    order[++pos] = node;
    for(const int &to : tree[node])
    {
        if(to == par)
        {
            continue;
        }

        dfs(to, node);
    }
}

int binary(int l, int r, int arr[], int k)
{
    int binL = l - 1, binR = r + 1;

    while(binL + 1 < binR)
    {
        int mid = binL + binR >> 1;

        if(arr[mid] <= k) binL = mid;
        else binR = mid;
    }

    return binL;
}

void divide(int l, int r, int arr[])
{
    if(l == r)
    {
        res = std::max(res, 1 + b[arr[l]]);
        return;
    }

    int mid = l + r >> 1;

    suffixA[mid] = 0;
    suffixB[mid] = b[mid];
    for(int i = mid - 1 ; i >= l ; --i)
    {
        suffixA[i] = suffixA[i + 1] + a[arr[i]];
        suffixB[i] = suffixB[i + 1] + b[arr[i]];
    }

    prefixA[mid + 1] = a[arr[mid + 1]];
    prefixB[mid + 1] = b[arr[mid + 1]];
    for(int i = mid + 2 ; i <= r ; ++i)
    {
        prefixA[i] = prefixA[i - 1] + a[arr[i]];
        prefixB[i] = prefixB[i - 1] + b[arr[i]];
    }

    for(int i = mid ; i >= l ; --i)
    {
        res = std::max(res, suffixB[i] + prefixB[binary(mid + 1, r, prefixA, t - suffixA[i])]);
    }
    
    divide(l, mid, arr);
    divide(mid + 1, r, arr);
}

void solve()
{
    dfs(1, 0);
    divide(1, n, order);
}

void input()
{
    std::cin >> n >> t;

    for(int i = 2 ; i <= n ; ++i)
    {
        std::cin >> parent[i];
        tree[parent[i]].push_back(i);
        tree[i].push_back(parent[i]);
    }

    for(int i = 2 ; i <= n ; ++i)
    {
        std::cin >> a[i];
    }
    
    for(int i = 1 ; i <= n ; ++i)
    {
        std::cin >> b[i];
    }
}

void output()
{
    std::cout << res << "\n";
}

void fastIO()
{
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL); 
    std::cout.tie(NULL);
}

signed main()
{
    fastIO();
    input();
    solve();
    output();
    return 0;
}