#include <iostream>
#include <algorithm>
#include <vector>

#define int long long

const int MAXN = 100000 + 10;
const int INF = 1e9 + 10;

int n, t;
int a[MAXN];
int b[MAXN];
int parent[MAXN];
std::vector<int> tree[MAXN];
int res;

int dfs(int node, int par, int timePassed)
{
    if(timePassed >= t)
    {
        return 0;
    }

    int cnt = 0;
    for(const int &to : tree[node])
    {
        if(to == par)
        {
            continue;
        }

        cnt += dfs(to, node, timePassed + 1);
    }

    return cnt + 1 + b[node];
}

void solve()
{
    for(int i = 1 ; i <= n ; ++i)
    {
        res = std::max(res, dfs(i, parent[i], 0));
    }
}

void input()
{
    std::cin >> n >> t;

    for(int i = 2 ; i <= n ; ++i)
    {
        std::cin >> parent[i];
        tree[parent[i]].push_back(i);
        tree[i].push_back(parent[i]);
    }

    for(int i = 2 ; i <= n ; ++i)
    {
        std::cin >> a[i];
    }
    
    for(int i = 1 ; i <= n ; ++i)
    {
        std::cin >> b[i];
    }
}

void output()
{
    std::cout << res << "\n";
}

void fastIO()
{
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL); 
    std::cout.tie(NULL);
}

signed main()
{
    fastIO();
    input();
    solve();
    output();
    return 0;
}