#include <bits/stdc++.h>
using namespace std;

struct DjiikstraEntry {
    int node, weight, time;
    DjiikstraEntry(int anode, int aweight, int atime) {
        node = anode;
        weight = aweight;
        time = atime;
    }

    const bool operator<(DjiikstraEntry b) const {
        return this->weight > b.weight;
    }
};

vector<vector<int>> adj;
vector<int> weight;
vector<vector<int>> reached;

// multi-source djiikstra?

int main() {
    int n, t;
    cin >> n >> t;
    adj.resize(n);
    weight.resize(n);
    reached.resize(n);

    for (int i = 1; i < n; i++) {
        int a;
        cin >> a;
        adj[a - 1].push_back({ i });
    }

    vector<int> time(n);
    time[0] = 0;
    for (int i = 1; i < n; i++) {
        cin >> time[i];
    }

    vector<int> workers(n);
    for (int i = 0; i < n; i++) {
        cin >> workers[i];
    }



    priority_queue<DjiikstraEntry> pq;
    for (int i = 0; i < n; i++) {
        pq.push(DjiikstraEntry(i, workers[i] + 1, 0));
    }

    for (int i = 0; i < n; i++) {
        weight[i] = workers[i];
    }


    while (!pq.empty()) {
        DjiikstraEntry top = pq.top();
        pq.pop();

        if (top.weight == weight[top.node]) continue;
        for (auto edge : adj[top.node]) {

            if (top.time + time[edge] > t) {
                //cout << top.node << " " << edge << " " << top.time + time[edge] << endl;
                continue;
            }

            if (top.weight + workers[edge] > weight[edge]) {
                weight[edge] = top.weight + workers[edge] + 1;
                //cout << top.time + time[edge] << endl;
                pq.push(DjiikstraEntry(edge, weight[edge], top.time + time[edge]));
                pq.push(DjiikstraEntry(top.node, weight[edge], top.time + time[edge]));

            }
        }
    }

    int ans = -1;
    for (auto x : weight) {
        ans = max(ans, x);
    }
    cout << ans << endl;
    for (int i = 0; i < n; i++) {
        //cout << i << ": ";
        for (auto x : adj[i]) {
            //cout << x << " ";
        }
        //cout << endl;
    }
}
