#include<iostream>
#include<vector>
#include<queue>
#include<algorithm>
using namespace std;
int main(){
    int N,T;
    cin>>N>>T;
    vector<vector<int>> children(N+1);
    vector<long long> time_to_notify(N+1, 0);
    vector<long long> team_size(N+1);
    if(N>1){
        for(int i = 2; i<=N;i++){
            int p;
            cin>>p;
            children[p].push_back(i);
        }
        for(int i=2; i<=N; i++){
            cin>>time_to_notify[i];
        }
    }
    for(int i = 1; i<=N; i++){
        cin>>team_size[i];
    }
    long long max_modified = 0;
    for(int start=1;start<=N;start++){
        queue<pair<int, long long>> q;
        q.push({start,0});
        long long total_employees = 0;
        long long num_managers= 0;
        while(!q.empty()){
            int curr = q.front().first;
            long long curr_time = q.front().second;
            q.pop();
            num_managers++;
            total_employees += team_size[curr];
            for(int child : children[curr]){
                long long notify_time = curr_time + time_to_notify[child];
                if(notify_time<=T){
                    q.push({child, notify_time});
                }
            }
        }
        long long total = num_managers + total_employees;
        max_modified = max(max_modified, total);
    }
    cout<<max_modified<<endl;
    return 0;
}
