#include <bits/stdc++.h>
#include <ext/pb_ds/assoc_container.hpp>
using namespace std;
using namespace __gnu_pbds;
using ordered_set = tree<long long, null_type, less<long long>, rb_tree_tag, tree_order_statistics_node_update>;
const long long mxN = 1e5+5;
struct FenwickTree{
    long long n;
    vector<long long> tree;
    FenwickTree(){
        n = 0;
    }
    FenwickTree(long long _n){
        n = _n;
        tree.resize(n);
    }
    void rsize(long long _n){
        n = _n;
        tree.resize(n);
    }
    void add(long long pos, long long val){
        for(int i=pos; i<n; i = (i | (i+1))){
            tree[i]+=val;
        }
    }
    long long query(long long pos){
        if(pos<0){
            return 0;
        }
        long long res = 0;
        for(int i=pos; i>=0; i = ((i&(i+1))-1)){
            res += tree[i];
        }
        return res;
    }
    long long query(long long left, long long right){
        return query(right)-query(left-1);
    }
};
vector<long long> p,t,a,dist;
vector<FenwickTree> fts;
vector<ordered_set> sts;
vector<long long> adj[mxN];
long long ans = 0, n, T;
void dfs(long long node, long long par){
    for(auto next : adj[node]){
        if(next==par){
            continue;
        }
        dist[next]=dist[node]+t[next];
        dfs(next,node);
    }
}
void dfs1(long long node, long long par){
    long long largest = -1, largestsz = -1;
    for(auto next : adj[node]){
        if(next==par){
            continue;
        }
        dfs1(next,node);
        if(sts[next].size()>largestsz){
            largestsz = sts[next].size();
            largest = next;
        }
    }
    if(largest!=-1)swap(fts[node],fts[largest]);
    if(largest!=-1)swap(sts[node],sts[largest]);
    for(auto next : adj[node]){
        if(next==par || next==largest){
            continue;
        }
        for(auto x : sts[next]){
            sts[node].insert(x);
        }
    }
    sts[node].insert(dist[node]);
    sts[node].insert(T+dist[node]);
    fts[node].rsize(sts[node].size());
    for(auto next : adj[node]){
        if(next==par || next==largest){
            continue;
        }
        for(auto x : sts[next]){
            fts[node].add(sts[node].order_of_key(x),fts[next].query(sts[next].order_of_key(x),sts[next].order_of_key(x)));
        }
    }
    fts[node].add(sts[node].order_of_key(dist[node]),a[node]+1);
    ans=max(ans,fts[node].query(sts[node].order_of_key(T+dist[node])));
}
int main(){
    ios::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);
    cin >> n >> T;
    p.resize(n+1); t.resize(n+1); a.resize(n+1); dist.resize(n+1); fts.resize(n+1); sts.resize(n+1);
    for(int i=2; i<=n; i++){
        cin >> p[i];
        adj[p[i]].push_back(i);
        adj[i].push_back(p[i]);
    }
    for(int i=2; i<=n; i++){
        cin >> t[i];
    }
    for(int i=1; i<=n; i++){
        cin >> a[i];
    }
    //dfs(1,0);
    //dfs1(1,0);
    long long left = 0, right = 0;
    long long cdistr = 0, cdistl = 0;
    vector<long long> pref(n+1);
    for(int i=1; i<=n; i++){
        pref[i]=a[i]+pref[i-1];
    }
    for(long long i=1; i<=n; i++){
        cdistr-=a[i-1];
        while(cdistr+a[right]<=T){
            cdistr+=a[right];
            right++;
        }
        right--;
        right=max(right,i);
        while(cdistl>T){
            cdistl-=a[left];
            left++;
        }
        left=min(left,i);
        ans=max(ans,pref[right]-pref[left-1]+right-left+1);
    }
    cout << ans << endl;
}
