#include <bits/stdc++.h>
#include <ext/pb_ds/assoc_container.hpp>
using namespace std;
using namespace __gnu_pbds;
using ordered_set = tree<int, null_type, less<int>, rb_tree_tag, tree_order_statistics_node_update>;
const int mxN = 1e5+5;
struct FenwickTree{
    int n;
    vector<int> tree;
    FenwickTree(){
        n = 0;
    }
    FenwickTree(int _n){
        n = _n;
        tree.resize(n);
    }
    void rsize(int _n){
        n = _n;
        tree.resize(n);
    }
    void add(int pos, int val){
        for(int i=pos; i<n; i = (i | (i+1))){
            tree[i]+=val;
        }
    }
    int query(int pos){
        if(pos<0){
            return 0;
        }
        int res = 0;
        for(int i=pos; i>=0; i = ((i&(i+1))-1)){
            res += tree[i];
        }
        return res;
    }
    int query(int left, int right){
        return query(right)-query(left-1);
    }
};
int cnt = 0;
vector<int> p,t,a,dist;
vector<FenwickTree> fts;
vector<ordered_set> sts;
vector<int> adj[mxN];
int ans = 0, n, T;
void dfs(int node, int par){
    for(auto next : adj[node]){
        if(next==par){
            continue;
        }
        dist[next]=dist[node]+t[next];
        dfs(next,node);
    }
}
void dfs1(int node, int par){
    int largest = -1, largestsz = -1;
    for(auto next : adj[node]){
        if(next==par){
            continue;
        }
        dfs1(next,node);
        if(sts[next].size()>largestsz){
            largestsz = sts[next].size();
            largest = next;
        }
    }
    if(largest!=-1)swap(fts[node],fts[largest]);
    if(largest!=-1)swap(sts[node],sts[largest]);
    for(auto next : adj[node]){
        if(next==par || next==largest){
            continue;
        }
        for(auto x : sts[next]){
            sts[node].insert(x);
        }
    }
    sts[node].insert(dist[node]);
    sts[node].insert(T+dist[node]);
    fts[node].rsize(sts[node].size());
    for(auto next : adj[node]){
        if(next==par || next==largest){
            continue;
        }
        for(auto x : sts[next]){
            fts[node].add(sts[node].order_of_key(x),fts[next].query(sts[next].order_of_key(x),sts[next].order_of_key(x)));
        }
    }
    fts[node].add(sts[node].order_of_key(dist[node]),a[node]+1);
    ans=max(ans,fts[node].query(sts[node].order_of_key(T+dist[node])));
}
int main(){
    ios::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);
    cin >> n >> T;
    p.resize(n+1); t.resize(n+1); a.resize(n+1); dist.resize(n+1); fts.resize(n+1); sts.resize(n+1);
    for(int i=2; i<=n; i++){
        cin >> p[i];
        adj[p[i]].push_back(i);
        adj[i].push_back(p[i]);
    }
    for(int i=2; i<=n; i++){
        cin >> t[i];
    }
    for(int i=1; i<=n; i++){
        cin >> a[i];
    }
    dfs(1,0);
    dfs1(1,0);
    cout << ans << endl;
}
