#include <bits/stdc++.h>
using namespace std;
const int maxN = 1e5 + 9;
const int maxX = 3e5 + 9;
int idx[256];
int8_t ch[5];
string a[maxN], p[maxN], s[maxN], s2[maxN];
int sufIdx[maxX];

struct sorter {
	struct Node {
		Node() {
			strIdx.clear();
			nxt[0] = nxt[1] = nxt[2] = nxt[3] = nxt[4] = nullptr;
		}
		vector<int> strIdx;
		Node* nxt[5];
	};
	Node* root;
	void init() { root = new Node(); }

	void add(const string& s, int strIdx) {
		Node* cur = root;
		for (int i = 0; i < s.size(); i++) {
			if (cur->nxt[idx[s[i]]] == nullptr) {
				cur->nxt[idx[s[i]]] = new Node();
			}
			cur = cur->nxt[idx[s[i]]];
		}
		cur->strIdx.push_back(strIdx);
	}
	int tmpIdx = 0;
	void traverse(Node* cur) {
		for (int i : cur->strIdx) { sufIdx[i] = tmpIdx; }
		if (cur->strIdx.size() != 0) { tmpIdx++; }
		for (int i = 0; i < 5; i++) {
			if (cur->nxt[i] != nullptr) { traverse(cur->nxt[i]); }
		}
	}
} sufS;

int bs(int x, const vector<int>& v) {
	int l = -1, r = v.size();
	while (l + 1 < r) {
		int mid = (l + r) / 2;
		if (v[mid] < x) {
			l = mid;
		} else {
			r = mid;
		}
	}
	return r;
}

struct Tree {
	struct Node {
		Node() {
			strIdx.clear();
			nxt[0] = nxt[1] = nxt[2] = nxt[3] = nxt[4] = nullptr;
		}
		vector<int> strIdx;
		Node* nxt[5];
	};
	Node* root;
	void init() { root = new Node(); }

	void add(const string& s, int strIdx) {
		Node* cur = root;
		for (int i = 0; i < s.size(); i++) {
			if (cur->nxt[idx[s[i]]] == nullptr) {
				cur->nxt[idx[s[i]]] = new Node();
			}
			cur = cur->nxt[idx[s[i]]];
			cur->strIdx.push_back(strIdx);
		}
	}
	void sortNodes(Node* cur) {
		sort(cur->strIdx.begin(), cur->strIdx.end());
		for (int i = 0; i < 5; i++) {
			if (cur->nxt[i] != nullptr) { sortNodes(cur->nxt[i]); }
		}
	}

	int query(string& s, int l, int r) {
		Node* cur = root;
		for (int i = 0; i < s.size(); i++) {
			cur = cur->nxt[idx[s[i]]];
			if (cur == nullptr) { return 0; }
		}
		return bs(r, cur->strIdx) - bs(l, cur->strIdx);
	}
} tr;

void addOne(string& s) {
	for (int i = s.size() - 1; i >= 0; i--) {
		if (idx[s[i]] == 3) { s[i] = ch[0]; }
		else { s[i] = ch[idx[s[i]] + 1]; return; }
	}
	for (int i = 0; i < s.size(); i++) { s[i] = ch[3]; }
	s.push_back(ch[4]);
}


bool compPr(const string& s1, const string& pr) {
	if (pr.size() > s1.size()) { return false; }
	for (int i = 0; i < pr.size(); i++) {
		if (pr[i] != s1[i]) { return false; }
	}
	return true;
}
bool compSuf(const string& s1, const string& suf) {
	if (suf.size() > s1.size()) { return false; }
	for (int i = 0; i < suf.size(); i++) {
		if (suf[suf.size() - i - 1] != s1[s1.size() - i - 1]) { return false; }
	}
	return true;
}
int main() {
	ios_base::sync_with_stdio(0);
	cin.tie(0);
	cout.tie(0);
	idx['A'] = 0; idx['C'] = 1; idx['G'] = 2; idx['U'] = 3; idx['?'] = 4;
	ch[0] = 'A'; ch[1] = 'C'; ch[2] = 'G'; ch[3] = 'U'; ch[4] = '?';

	int n, q;
	cin >> n >> q;
	for (int i = 0; i < n; i++) { cin >> a[i]; }

	for (int i = 0; i < q; i++) {
		cin >> p[i]; cin >> s[i];
		int ans = 0;
		for (int j = 0; j < n; j++) {
			ans += compPr(a[j], p[i]) && compSuf(a[j], s[i]);
		}
		cout << ans << '\n';
	}
}
/**
3 6
AUGC
AUUUUGC
ACGUUUUUC
A C
AU C
AU GC
A UGC
AU UGC
A CGG
*/
