#include <bits/stdc++.h>
#include "unique.h"
#include "grader.cpp"
using namespace std;
const int maxN = 1e5 + 1, maxA = 1e5 + 1;
int last[maxA];
vector<int> a, nxt, prev_;
int n;

struct Seg2d {
	~Seg2d() { del(); };
	struct Node {
		Node() {
			lX = rX = lY = rY = val = 0;
			ch[0] = ch[1] = ch[2] = ch[3] = nullptr;
		}
		int lX, rX, lY, rY, val;
		Node* ch[4];
	};
	vector<Node*> nodes;
	Node* root;

	void init() {
		del();
		root = new Node();
		root->rX = root->rY = n - 1;
		initRec(*root);
	}

	void update(int lX, int rX, int lY, int rY, int val, Node& cN) {
		if (cN.rX < lX || rX < cN.lX || cN.rY < lY || rY < cN.lY) { return; }
		if (lX <= cN.lX && cN.rX <= rX && lY <= cN.lY && cN.rY <= rY) {
			cN.val += val;
			return;
		}
		for (int i = 0; i < 4; i++) { update(lX, rX, lY, rY, val, *cN.ch[i]); }
	}

	int query(int x, int y, Node& cN) {
		if (x == cN.lX && cN.rX == x && y == cN.lY && cN.rY == y) {
			return cN.val;
		}
		int tmp1 = x > cN.ch[0]->rX;
		int tmp2 = y > cN.ch[0]->rY;
		return cN.val + query(x, y, *cN.ch[tmp1 | (tmp2 << 1)]);
	}

private:
	void del() {
		for (auto i : nodes) { delete i; }
		nodes.clear();
		root = nullptr;
	}
	void initRec(Node& cN) {
		if (cN.rX < cN.lX || cN.rY < cN.lY || (cN.rX == cN.lX && cN.rY == cN.lY)) { return; }
		cN.ch[0] = new Node(); cN.ch[1] = new Node();
		cN.ch[2] = new Node(); cN.ch[3] = new Node();

		cN.ch[0]->lX = cN.lX;
		cN.ch[0]->rX = (cN.lX + cN.rX) / 2;
		cN.ch[0]->lY = cN.lY;
		cN.ch[0]->rY = (cN.lY + cN.rY) / 2;

		cN.ch[1]->lX = (cN.lX + cN.rX) / 2 + 1;
		cN.ch[1]->rX = cN.rX;
		cN.ch[1]->lY = cN.lY;
		cN.ch[1]->rY = (cN.lY + cN.rY) / 2;


		cN.ch[2]->lX = cN.lX;
		cN.ch[2]->rX = (cN.lX + cN.rX) / 2;
		cN.ch[2]->lY = (cN.lY + cN.rY) / 2 + 1;
		cN.ch[2]->rY = cN.rY;

		cN.ch[3]->lX = (cN.lX + cN.rX) / 2 + 1;
		cN.ch[3]->rX = cN.rX;
		cN.ch[3]->lY = (cN.lY + cN.rY) / 2 + 1;
		cN.ch[3]->rY = cN.rY;
		for (int i = 0; i < 4; i++) { nodes.push_back(cN.ch[i]); }
		for (int i = 0; i < 4; i++) { initRec(*cN.ch[i]); }
	}
} st;

void reInit() {
	n = a.size();
	nxt.clear(); nxt.resize(n);
	prev_.clear(); prev_.resize(n);

	for (int i = 0; i < n; i++) { last[a[i]] = -1; }
	for (int i = 0; i < n; i++) {
		prev_[i] = last[a[i]];
		last[a[i]] = i;
	}
	for (int i = 0; i < n; i++) { last[a[i]] = n; }
	for (int i = n - 1; i >= 0; i--) {
		nxt[i] = last[a[i]];
		last[a[i]] = i;
	}

	for (int i = 0; i < n; i++) { last[a[i]] = n; }
	st.init();
	for (int i = 0; i < n; i++) {
		st.update(prev_[i] + 1, i, i, nxt[i] - 1, 1, *st.root);
	}
}
void init (vector<int> A) {
	a = A;
	reInit();
}

vector<int> queries (vector<pair<int, int>> S) {
	vector<int> ans;
	for (auto [l, r] : S) {
		ans.push_back(st.query(l, r, *st.root));
	}
	return ans;
}

void update(int I, int V) {
	a[I] = V;
	reInit();
}
