#include <bits/stdc++.h>
#include "unique.h"
using namespace std;
const int maxN = 1e5 + 1, maxA = 1e5 + 1;
int last[maxA];
vector<int> a, nxt, prev_;
vector<vector<pair<pair<int, int>, int>>> q;
int n;

struct PersSeg {
	~PersSeg() { del(); };
	struct Node {
		Node() { lCh = rCh = nullptr; l = r = val = tree = 0; }
		Node(int tr) { tree = tr; lCh = rCh = nullptr; l = r = val = 0; }
		Node& operator=(const Node& rhs) {
			l = rhs.l; r = rhs.r;
			val = rhs.val; tree = rhs.tree;
			lCh = rhs.lCh; rCh = rhs.rCh;
			return *this;
		}
		int l, r;
		int val, tree;
		Node* lCh, *rCh;
	};
	vector<Node*> nodes;
	vector<Node> node;
	int trCnt = 0;

	void init() {
		del();
		trCnt = 0;
		node.clear(); nodes.clear();
		Node* cNode = new Node(trCnt++);
		cNode->l = 0; cNode->r = n - 1;
		nodes.push_back(cNode);
		node.push_back(*cNode);
	}
	void newTree() {
		Node* cNode = new Node();
		*cNode = node.back();
		cNode->tree = trCnt++;
		nodes.push_back(cNode);
		node.push_back(*cNode);
	}
	void update(int l, int r, int val, Node& cN) {
		if (cN.r < l || r < cN.l) { return; }
		if (l <= cN.l && cN.r <= r) {
			cN.val += val;
			return;
		}
		newNodes(cN);
		update(l, r, val, *cN.lCh);
		update(l, r, val, *cN.rCh);
	}

	int query(int idx, Node& cN) {
		if (cN.l == idx && cN.r == idx) { return cN.val; }
		if (cN.lCh == nullptr) { return cN.val; }
		if (idx <= cN.lCh->r) {
			return query(idx, *cN.lCh) + cN.val;
		} else {
			return query(idx, *cN.rCh) + cN.val;
		}
	}
private:
	void newNodes(Node& cN) {
		if (cN.lCh == nullptr) {
			cN.lCh = new Node(); cN.rCh = new Node();
			cN.lCh->tree = cN.rCh->tree = cN.tree;
			cN.lCh->l = cN.l;
			cN.lCh->r = (cN.l + cN.r) / 2;
			cN.rCh->l = (cN.l + cN.r) / 2 + 1;
			cN.rCh->r = cN.r;
			nodes.push_back(cN.lCh);
			nodes.push_back(cN.rCh);
		} else if (cN.lCh->tree != cN.tree) {
			Node* tmpL = new Node(), *tmpR = new Node();
			*tmpL = *cN.lCh; *tmpR = *cN.rCh;
			tmpL->tree = tmpR->tree = cN.tree;
			cN.lCh = tmpL;
			cN.rCh = tmpR;
			nodes.push_back(cN.lCh);
			nodes.push_back(cN.rCh);
		}
	}
	void del() {
		for (auto i : nodes) { delete i; }
		node.clear();
	}
} st;

void reInit() {
	n = a.size();
	nxt.clear(); nxt.resize(n);
	prev_.clear(); prev_.resize(n);
	q.clear(); q.resize(n);

	for (int i = 0; i < n; i++) { last[a[i]] = -1; }
	for (int i = 0; i < n; i++) {
		prev_[i] = last[a[i]];
		last[a[i]] = i;
	}
	for (int i = 0; i < n; i++) { last[a[i]] = n; }
	for (int i = n - 1; i >= 0; i--) {
		nxt[i] = last[a[i]];
		last[a[i]] = i;
	}

	for (int i = 0; i < n; i++) { last[a[i]] = n; }
	st.init();
	for (int i = 0; i < n; i++) {
		q[prev_[i] + 1].push_back({ { i, nxt[i] - 1 }, 1 });
		if (i != n - 1) {
			q[i + 1].push_back({ { i, nxt[i] - 1 }, -1 });
		}
	}
	for (int i = 0; i < n; i++) {
		if (i != 0) { st.newTree(); }
		for (auto x : q[i]) {
			int l = x.first.first, r = x.first.second, val = x.second;
			st.update(l, r, val, st.node[i]);
		}
	}
}
void init (vector<int> A) {
	a = A;
	reInit();
}

vector<int> queries (vector<pair<int, int>> S) {
	vector<int> ans;
	for (auto [l, r] : S) {
		ans.push_back(st.query(r, st.node[l]));
	}
	return ans;
}

void update(int I, int V) {
	a[I] = V;
	reInit();
}
