#include "testlib.h"
#include<iostream>
#include<string>
#include<vector>
#define MAXN 100000
using namespace std;
int nodes[4*MAXN];
void build (int ind, int l, int r, vector <int>& init) {
    if (l==r) {
        nodes[ind]=init[l];
        return ;
    }
    int mid=(l+r)/2;
    build(2*ind+1,l,mid,init);
    build(2*ind+2,mid+1,r,init);
    nodes[ind]=max(nodes[2*ind+1],nodes[2*ind+2]);
}
int query (int ind, int l, int r, int ql, int qr) {
    if ((ql<=l)&&(r<=qr)) return nodes[ind];
    int mid=(l+r)/2;
    int ans=-1;
    if (ql<=mid) ans=max(ans,query(2*ind+1,l,mid,ql,qr));
    if (qr>mid) ans=max(ans,query(2*ind+2,mid+1,r,ql,qr));
    return ans;
}
void update (int ind, int l, int r, int pos, int val) {
    if (l==r) {
        nodes[ind]=val;
        return ;
    }
    int mid=(l+r)/2;
    if (pos<=mid) update(2*ind+1,l,mid,pos,val);
    else update(2*ind+2,mid+1,r,pos,val);
    nodes[ind]=max(nodes[2*ind+1],nodes[2*ind+2]);
}

int a[MAXN],n;
set <int> inds[MAXN+1];
void change (int i, int type) {
    int val=a[i];
    auto it=inds[val].find(i);
    it--;
    int prv=(*it),prv2=-1;
    if (prv!=-1) {
        it--;
        prv2=(*it);
        it++;
    }
    it++;
    it++;
    int nxt=(*it),nxt2=1e9;
    if (nxt<n) {
        it++;
        nxt2=(*it);
        it--;
    }
    it--;
    if (type==-1) {
        update(0,0,n-1,i,-1);
        if (nxt<n) update(0,0,n-1,nxt,prv2);
        if (nxt2<n) update(0,0,n-1,nxt2,prv);
    }
    else {
        update(0,0,n-1,i,prv2);
        if (nxt<n) update(0,0,n-1,nxt,prv);
        if (nxt2<n) update(0,0,n-1,nxt2,i);
    }
}

void error_message (const char message[]) {
    cerr << "Error - " << message << "\n";
    exit(0);
}
int main (int argc, char* argv[]) {
    if (argc==1) error_message("the test validator needs arguments!\n");
    FILE* fin;
    fin=fopen(argv[1],"r");
    if (fin==NULL) error_message("wrong test name!");
    fclose(fin);
    freopen(argv[1],"r",stdin);
    registerValidation(argc,argv);

    n=inf.readInt(1,MAXN,"N"); inf.readSpace();
    int q=inf.readInt(1,MAXN,"Q"); inf.readEoln();
    bool f=inf.readInt(0,1,"f"); inf.readEoln();
    for (int i=0; i<n; i++) {
        a[i]=inf.readInt(1,n,"a_"+to_string(i));
        if (i!=n-1) inf.readSpace();
    }
    inf.readEoln();

    for (int val=1; val<=n; val++) {
        inds[val].insert(-1);
        inds[val].insert(n);
    }
    for (int i=0; i<n; i++) {
        int val=a[i];
        inds[val].insert(i);
    }
    vector <int> tmp(n);
    for (int val=1; val<=n; val++) {
        for (auto it=inds[val].begin(); it!=inds[val].end(); it++) {
            if ((it==inds[val].begin())||(it==(--inds[val].end()))) continue;
            it--;
            int prv2=-1;
            if (it!=inds[val].begin()) {
                it--;
                prv2=(*it);
                it++;
            }
            it++;
            tmp[(*it)]=prv2;
        }
    }
    build(0,0,n-1,tmp);

    bool flag=true;
    int updates=0;
    for (int i=0; i<q; i++) {
        int t=inf.readInt(1,2,"t_"+to_string(i)); inf.readSpace();
        if (t==1) {
            int l=inf.readInt(0,n-1,"l_"+to_string(i)); inf.readSpace();
            int r=inf.readInt(l,n-1,"r_"+to_string(i));
            if ((flag==true)&&(query(0,0,n-1,l,r)>=l)) flag=false;
        }
        else {
            updates++;
            ensuref(f==false,"f is false but there are updates!");
            int ind=inf.readInt(0,n-1,"ind_"+to_string(i)); inf.readSpace();
            int val=inf.readInt(1,n,"val_"+to_string(i));

            if (flag==true) {
                change(ind,-1);
                inds[a[ind]].erase(ind);
                a[ind]=val;
                inds[a[ind]].insert(ind);
                change(ind,+1);
            }
        }
        inf.readEoln();
    }
    inf.readEof();

    cout << n << " " << q << " " << f << endl ;
    cout << flag << " " << updates << endl ;
    HANDLE handle=GetStdHandle(STD_OUTPUT_HANDLE);
    SetConsoleTextAttribute(handle,10);
    if ((n<=10000)&&(q<=10000)&&(updates<=10000)) cout << "First subtask!\n";
    else if ((n<=MAXN)&&(q<=MAXN)&&(updates==0)&&(f==true)) cout << "Second subtask!\n";
    else if ((n<=MAXN)&&(q<=MAXN)&&(updates==0)&&(flag==true)) cout << "Third subtask!\n";
    else if ((n<=MAXN)&&(q<=MAXN)&&(updates==0)) cout << "Fourth subtask!\n";
    else if ((n<=MAXN)&&(q<=MAXN)&&(updates<=10000)&&(flag==true)) cout << "Fifth subtask!\n";
    else if ((n<=MAXN)&&(q<=MAXN)&&(updates<=10000)) cout << "Sixth subtask!\n";
    else {
        SetConsoleTextAttribute(handle,12);
        cout << "? subtask!\n";
    }
    SetConsoleTextAttribute(handle,7);
    return 0;
}
