#include<iostream>
#include<iomanip>
#include<fstream>
#include<vector>
using namespace std;
extern void init (std::vector <int> A);
extern std::vector <int> queries (std::vector <std::pair <int, int>> S);
extern void update (int I, int V);
static const long long int mod=865957969,base=508027561;
static void calc_hash (long long int& hash1, int value) {
    hash1*=base; hash1+=value;
    hash1%=mod;
}
int main (int argc, char* args[]) {
    double beg_input=clock();
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    int n,q;
    cin >> n >> q ;
    long long int hash1=0;
    calc_hash(hash1,n);
    calc_hash(hash1,q);
    bool f;
    cin >> f ;
    calc_hash(hash1,f);
    vector <int> a(n);
    for (int i=0; i<n; i++) {
        cin >> a[i] ;
        calc_hash(hash1,a[i]);
    }
    vector <tuple <int, int, int>> input(q);
    int cnt=0;
    for (int i=0; i<q; i++) {
        int t,x,y;
        cin >> t >> x >> y ;
        calc_hash(hash1,t);
        calc_hash(hash1,x);
        calc_hash(hash1,y);
        input[i]={t, x, y};
        if (t==1) cnt++;
    }
    vector <vector <int>> output;
    vector <pair <int, int>> s;
    if (f==false) output.reserve(cnt);
    if (f==true) {
        s.reserve(cnt);
        for (int i=0; i<q; i++) {
            auto [t, x, y]=input[i];
            if (t==1) s.push_back({x, y});
        }
    }
    double end_input=clock();
    ofstream fout(args[1]);
    fout << "io-time:" << fixed << setprecision(3) << (end_input-beg_input)/CLOCKS_PER_SEC << endl ;
    fout.close();

    init(a);
    a.clear();
    bool exit=false;
    if (f==false) {
        for (int i=0; i<q; i++) {
            auto [t, x, y]=input[i];
            if (t==1) {
                output.push_back(queries({{x, y}}));
                if ((int)output.size()>cnt) {
                    exit=true;
                    break;
                }
            }
            else if (t==2) update(x,y);
        }
    }
    else output.push_back(queries(s));

    double beg_output=clock();
    cout << hash1 << "\n";
    if (exit==false) {
        for (auto ans : output) {
            for (unsigned int i=0; i<ans.size(); i++) {
                if (i!=0) cout << " ";
                cout << ans[i] ;
            }
            cout << "\n";
        }
    }
    double end_output=clock();
    fout.open(args[1]);
    fout << "io-time:" << fixed << setprecision(3) << (end_input-beg_input+end_output-beg_output)/CLOCKS_PER_SEC << endl ;
    fout.close();
    return 0;
}
