/* the checker has three arguments:
    - first - name of the input file
    - second - name of the correct output file
    - third - name of the contestant output file */
#include<iostream>
#include<fstream>
#include<vector>
using namespace std;
void output_message (double points, string message) {
    cout << points << endl ;
    cerr << message << endl ;
    exit(0);
}
static const long long int mod=865957969,base=508027561;
static void calc_hash (long long int& hash1, int value) {
    hash1*=base; hash1+=value;
    hash1%=mod;
}
int main (int argc, char** argv) {
    ifstream inp,ans,out;
    if (argc<4) output_message(0,"The checker needs input file, correct output and contestant output!");
    inp.open(argv[1]);
    if (inp.is_open()==false) output_message(0,"Could not open input file!");
    ans.open(argv[2]);
    if (ans.is_open()==false) output_message(0,"Could not open correct output file!");
    out.open(argv[3]);
    if (out.is_open()==false) output_message(0,"Could not open contestant output file!");

    int hash2;
    if (!(out >> hash2)) output_message(0,"Violation of the protocol for communication!");
    int n,q;
    inp >> n >> q ;
    long long int hash1=0;
    calc_hash(hash1,n);
    calc_hash(hash1,q);
    bool f;
    inp >> f ;
    calc_hash(hash1,f);
    for (int i=0; i<n; i++) {
        int num;
        inp >> num ;
        calc_hash(hash1,num);
    }
    for (int i=0; i<q; i++) {
        int t,x,y;
        inp >> t >> x >> y ;
        calc_hash(hash1,t);
        calc_hash(hash1,x);
        calc_hash(hash1,y);
    }
    if (hash1!=hash2) output_message(0,"Violation of the protocol for communication!");

    for (;;) {
        int ans1;
        if (!(ans >> ans1 )) break;
        int ans2;
        if (!(out >> ans2)) output_message(0,"Violation of the protocol for communication!");
        if (ans1!=ans2) output_message(0,"Wrong answer!");
    }
    char temp;
    if (out >> temp) output_message(0,"Violation of the protocol for communication!");

    output_message(1,"OK!");
    return 0;
}
