#include <iostream>

using namespace std;

/**
 * Функция за бързо модулно степенуване: (base^exp) % mod
 */
long long power_mod(long long base, long long exp, long long mod) {
    long long res = 1;
    base %= mod;
    while (exp > 0) {
        if (exp % 2 == 1) res = (__int128(res) * base) % mod;
        base = (__int128(base) * base) % mod;
        exp /= 2;
    }
    return res;
}

int main() {
    long long a, m, n;
    if (!(cin >> a >> m >> n)) return 0;

    // 1. Намираме остатъка r преди позиция m.
    // Това е 10^(m-1) % a.
    long long r = power_mod(10, m - 1, a);

    // 2. Генерираме цифрите от m до n
    for (long long i = m; i <= n; ++i) {
        r *= 10;
        cout << (long long)(r / a); // Настоящата цифра
        r %= a;                     // Нов остатък
    }
    cout << endl;

    return 0;
}