#include <iostream>
#include <algorithm>
#include <vector>

using namespace std;

struct Option {
    long long x, y, sum;
};

int main() {
    long long N, M, K, T;
    cin >> N >> M >> K >> T;

    vector<Option> options;

    // Вариант 1: Гарантираме и двата цвята обувки (ако е възможно)
    // Трябва да вземем MAX(бели, черни) не е достатъчно, трябва да вземем 
    // всички от единия цвят + 1, за да сме сигурни, че имаме и от двата.
    options.push_back({N + 1, 1, N + 1 + 1});
    options.push_back({M + 1, 1, M + 1 + 1});

    // Вариант 2: Гарантираме и двата цвята чанти
    options.push_back({1, K + 1, 1 + K + 1});
    options.push_back({1, T + 1, 1 + T + 1});

    Option best = {-1, -1, -1};

    for (auto opt : options) {
        // Проверка дали количествата са налични в гардероба
        // В задачата се казва "извадила X", така че X <= N+M и Y <= K+T
        if (opt.x <= N + M && opt.y <= K + T) {
            if (best.sum == -1 || opt.sum < best.sum) {
                best = opt;
            } else if (opt.sum == best.sum) {
                if (opt.x > best.x) {
                    best = opt;
                }
            }
        }
    }

    cout << best.x << " " << best.y << endl;

    return 0;
}
Използвайте кода внимателно.