#include <bits/stdc++.h>
#define int long long
#define endl '\n'

using namespace std;

const int MAXN = 2e5;
const int MAXNUM = 2e6;

int a[MAXN + 5], b[MAXN + 5], tree[4 * MAXNUM + 5], lazy[4 * MAXNUM + 5];

void push_lazy(int v, int l, int r)
{
    if(lazy[v] != 0)
    {
        tree[v] += lazy[v] * (r - l + 1);

        if(l != r)
        {
            lazy[v * 2] += lazy[v];
            lazy[v * 2 + 1] += lazy[v];
        }

        lazy[v] = 0;
    }
}

void update(int v, int l, int r, int ql, int qr, int val)
{
    push_lazy(v, l, r);
    if(ql > r || l > qr)return;

    if(ql <= l && r <= qr)
    {
        lazy[v] += val;
        push_lazy(v, l, r);
        return;
    }

    int mid = (l + r) / 2;

    update(v * 2, l, mid, ql, qr, val);
    update(v * 2 + 1, mid + 1, r, ql, qr, val);

    tree[v] = tree[v * 2] + tree[v * 2 + 1];
}

int query(int v, int l, int r, int ql, int qr)
{
    push_lazy(v, l, r);

    if(ql > r || l > qr)return 0;
    if(ql <= l && r <= qr)return tree[v];

    int mid = (l + r) / 2;

    return query(v * 2, l, mid, ql, qr) + query(v * 2 + 1, mid + 1, r, ql, qr);
}

signed main()
{
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(nullptr); std::cout.tie(nullptr);

    int n, m; cin >> n >> m;

    for(int i = 1; i <= n; i++)
    {
        cin >> a[i] >> b[i];

        update(1, 0, MAXNUM, b[i], m - 1, 1);


        a[i] -= (m - b[i]);

        update(1, 0, MAXNUM, 0, m - 1, a[i] / m);

        //cout << a[i] % m << endl;

        if(a[i] % m != 0)update(1, 0, MAXNUM, 0, a[i] % m - 1, 1);

        //cout << query(1, 0, MAXNUM, 1, 1) << endl;

    }


    int q; cin >> q;

    while(q--)
    {
        int t; cin >> t;
        cout << query(1, 0, MAXNUM, t, t) << endl;
    }


    return 0;
}

