#include <bits/stdc++.h>
#define int long long
using namespace std;

const int maxn=100000;
int n, k;
vector<int> g[maxn+110];
int root1, root2;
int dist[maxn+10];
int farthestNode, farthestDistance;
vector<int> diameterPath, path;
int height[maxn+110];
bool used[maxn+110];
int ancestors[maxn+110];
int ansDistance;

void dfsPath(int u)
{
    if(dist[u]>farthestDistance)
    {
        farthestDistance=dist[u];
        farthestNode=u;
        diameterPath=path;
    }

    for(auto v: g[u])
    {
        if(dist[v]==0)
        {
            dist[v]=dist[u]+1;
            path.push_back(v);
            dfsPath(v);
            path.pop_back();
        }
    }
}

void dfsDef(int u)
{
    if(dist[u]>farthestDistance)
    {
        farthestDistance=dist[u];
        farthestNode=u;
    }

    for(auto v: g[u])
    {
        if(dist[v]==0)
        {
            dist[v]=dist[u]+1;
            dfsDef(v);
        }
    }
}

int dfsHeight(int u)
{
    ///cout<<"DFS for height: "<<u+1<<";\n";
    bool isLeaf=true;
    used[u]=true;
    for(auto v: g[u])
    {
        if(!used[v])
        {
            height[u]=max(height[u], dfsHeight(v)+1);
            isLeaf=false;
        }
    }

    if(isLeaf) return 0;
    else return height[u];
}

int dfsAncestors(int u)
{
    used[u]=1;

    for(auto v: g[u])
    {
        if(!used[v])
        {
            ancestors[u]+=dfsAncestors(v)+1;
        }
    }

    return ancestors[u];
}

void findRootHeightAndAncestors()
{
    dist[0]=1;
    dfsDef(0);
    int currFarthest=farthestNode;
    for(int i=0; i<n; i++)
    {
        dist[i]=0;
    }
    dist[currFarthest]=1;
    path.push_back(currFarthest);
    farthestDistance=0;
    dfsPath(currFarthest);

    ///for(auto i: diameterPath) cout<<i<<' ';

    root1=diameterPath[farthestDistance/2];
    root2=diameterPath[farthestDistance/2+1];
    ///cout<<root+1<<'\n';


    ///cout<<"Generated ancestors...\n";
}

void dfsMain(int u)
{
    ///cout<<"DFS for answer: "<<u+1<<";\n";
    if(dist[u]>ansDistance)
    {
        ansDistance=dist[u];
    }
    used[u]=1;
    vector<pair<pair<int, int>, int>> children; ///{{height, ancestors}, node}

    for(auto v: g[u])
    {
        if(!used[v])
        {
            children.push_back({{height[v], ancestors[v]}, v});
        }
    }
    sort(children.begin(), children.end());
    int cnt=0;
//    cout<<"Node: "<<u+1<<"; Children: \n";
//    for(auto [p, v]: children)
//    {
//        cout<<"---Height: "<<p.first<<"; Ancestors: "<<p.second<<"; Node: "<<v+1<<'\n';
//    }
//    cout<<'\n';
    for(int i=children.size()-1; i>=0; i--, cnt++)
    {
        dist[children[i].second]=dist[u]+cnt/k+1;
        dfsMain(children[i].second);
    }
}

signed main()
{
    ios_base::sync_with_stdio(0);
    cin.tie(nullptr);

    cin>>n>>k;

    for(int i=0; i<n-1; i++)
    {
        int u, v;
        cin>>u>>v; u--; v--;

        g[u].push_back(v);
        g[v].push_back(u);
    }

    findRootHeightAndAncestors();

    used[root1]=1;
    dfsHeight(root1);


    for(int i=0; i<n; i++) used[i]=0;
    dfsAncestors(root1);
    for(int i=0; i<n; i++) {dist[i]=0; used[i]=0;}
    used[root1]=1;
    dist[root1]=0;

    dfsMain(root1);

    for(int i=0; i<n; i++) {dist[i]=0; used[i]=0;}
    used[root2]=1;
    dfsHeight(root2);


    for(int i=0; i<n; i++) used[i]=0;
    dfsAncestors(root2);
    for(int i=0; i<n; i++) {dist[i]=0; used[i]=0;}
    used[root2]=1;
    dist[root2]=0;

    dfsMain(root1);

    cout<<ansDistance<<'\n';

    return 0;
}
