#include<iostream>
#include<vector>
#include<stack>
#include<math.h>
using namespace std;
vector<int> edges[100002];
int visited[100002];
int N, K;
void bfs(int start)
{
    for(int i = 1; i <= N; i++) visited[i] = -1;
    stack<int> vertex;
    vertex.push(start);
    visited[start] = 0;
    while(!vertex.empty())
    {
        int cur = vertex.top();
        vertex.pop();
        for(int i = 0; i < edges[cur].size(); i++)
        {
            int edge = edges[cur][i];
            if(visited[edge] == -1)
            {
                vertex.push(edge);
                visited[edge] = visited[cur] + 1;
            }
        }
    }
}

bool visited1[100002];
int children[100002];
void dfs(int cur, int prev)
{
    int nodes = 0;
    for(int i = 0; i < edges[cur].size(); i++)
    {
        if(!visited1[edges[cur][i]])
        {
            nodes++;
            visited1[edges[cur][i]] = true;
            dfs(edges[cur][i], cur);
        }
    }
    if(nodes == 0) children[cur] = 0;
    if(prev != -1) children[prev]+=children[cur]+1;
}

int main()
{
    cin>>N>>K;
    for(int i = 0; i < N-1; i++)
    {
        int a, b;
        cin>>a>>b;
        edges[a].push_back(b);
        edges[b].push_back(a);
    }
    for(int i = 1; i <= N; i++) {visited1[i] = false; children[i] = 0;}
    visited1[1] = true;
    dfs(1, -1);
    cout<<ceil((N-2)/K)<<"\n";
    return 0;
}
