#include <bits/stdc++.h>
#define all(A) A.begin(), A.end()
using namespace std;
template <class T> using matrix = vector <vector <T>>;
matrix <pair <int, int>> g;

const int MAXN = 1e5;

int t;
int tin[MAXN + 5], tout[MAXN + 5];
int len_down[MAXN + 5];
int d[MAXN + 5];
int n, k;
bool used[MAXN + 5];
vector <int> path;

bool is_ancestor(int a, int b) {
    return tin[a] <= tin[b] && tout[b] <= tout[a];
}

void find_f(int u, int p, int dist) {
    d[u] = dist;
    tin[u] = t++;
    for (auto [x, v] : g[u]) {
        if (v == p) continue;
        find_f(v, u, dist + 1);
    }
    tout[u] = t++;
}

void dfs(int u, int p) {
    for (auto &[x, v] : g[u]) {
        if (v == p) continue;
        dfs(v, u);
        x = len_down[v] + 1;
        len_down[u] = max(len_down[u], x);
    }
    sort(all(g[u])); reverse(all(g[u]));
}

void go_down (int u, int a, int p) {
    path.push_back(u);
    if (u == a) return;
    for (auto [x, v] : g[u]) {
        if (v == p) continue;
        if (is_ancestor(v, a)) {
            go_down(v, a, u);
        }
    }
}

int dfs_ans(int u, int p) {
    if (g[u].size() == 1 && p != 0) return 0;
    vector <int> v;
    for (auto [x, v1] : g[u]) {
        if (v1 == p) continue;
        v.push_back(dfs_ans(v1, u));
    }
    int ans = 0;
    int add = 1;
    sort(all(v));
    for (int i = v.size() - 1; i >= 0; i -= k) {
        ans = max(ans, v[i] + add);
        add++;
    }
    return ans;
}



int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cin >> n >> k;
    g.resize(n + 1);
    for (int i = 1; i < n; i++) {
        int x, y; cin >> x >> y;
        g[x].push_back({0, y});
        g[y].push_back({0, x});
    }
    find_f(1, 0, 0);
    int mxd = 0, a = 0;
    for (int i = 1; i <= n; i++) {
        if (d[i] > mxd) {
            mxd = d[i];
            a = i;
        }
    }
    t = 1;
    find_f(a, 0, 0);
    int b = 0; mxd = 0;
    for (int i = 1; i <= n; i++) {
        if (d[i] > mxd) {
            mxd = d[i];
            b = i;
        }
    }
    go_down(a, b, 0);
    if (path.size() % 2 == 1) {
        cout << dfs_ans(path[path.size() / 2], 0) << endl;
    }
    else {
        cout << max(dfs_ans(path[path.size() / 2], 0), dfs_ans(path[path.size() / 2 - 1], 0)) << endl;
    }
}
