#include <bits/stdc++.h>
#define all(A) A.begin(), A.end()
using namespace std;
template <class T> using matrix = vector <vector <T>>;
matrix <pair <int, int>> g;

const int MAXN = 1e5;

int t;
int tin[MAXN + 5], tout[MAXN + 5];
int len_down[MAXN + 5];
int d[MAXN + 5];
int n, k;
bool used[MAXN + 5];
vector <int> path;

bool is_ancestor(int a, int b) {
    return tin[a] <= tin[b] && tout[b] <= tout[a];
}

void find_f(int u, int p, int dist) {
    d[u] = dist;
    tin[u] = t++;
    for (auto [x, v] : g[u]) {
        if (v == p) continue;
        find_f(v, u, dist + 1);
    }
    tout[u] = t++;
}

void dfs(int u, int p) {
    for (auto &[x, v] : g[u]) {
        if (v == p) continue;
        dfs(v, u);
        x = len_down[v] + 1;
        len_down[u] = max(len_down[u], x);
    }
    sort(all(g[u])); reverse(all(g[u]));
}

void go_down (int u, int a, int p) {
    path.push_back(u);
    if (u == a) return;
    for (auto [x, v] : g[u]) {
        if (v == p) continue;
        if (is_ancestor(v, a)) {
            go_down(v, a, u);
        }
    }
}

int calc(int a) {
    for (int i = 1; i <= n; i++) {
        used[i] = false;
        len_down[i] = 0;
    }
    dfs(a, 0);
    queue <int> q;
    q.push(a);
    int br = 0;
    int ans = 0;
    ///cout << 1 << endl;
    while (br < n) {
        ans++;
        queue <int> nq;
        while (!q.empty()) {
            int u = q.front(); q.pop();
            ///cout << u << " " << ans << endl;
            if (!used[u])br++;
            used[u] = true;
            int cur = k;
            for (auto [x, v] : g[u]) {
                if (cur == 0) break;
                if (used[v]) continue;
                cur--;
                nq.push(v);
            }
            if (cur == 0) {
                nq.push(u);
            }
        }
        q = nq;
    }
    return ans;
}

int main() {
    ios_base::sync_with_stdio(false); 
    cin.tie(0);
    cin >> n >> k;
    g.resize(n + 1);
    for (int i = 1; i < n; i++) {
        int x, y; cin >> x >> y;
        g[x].push_back({0, y});
        g[y].push_back({0, x});
    }
    cout << (n - 1 + k - 1) / k << endl;
    return 0;
    find_f(1, 0, 0);
    int mxd = 0, a = 0;
    for (int i = 1; i <= n; i++) {
        if (d[i] > mxd) {
            mxd = d[i];
            a = i;
        }
    }
    t = 1;
    find_f(a, 0, 0);
    int b = 0; mxd = 0;
    for (int i = 1; i <= n; i++) {
        if (d[i] > mxd) {
            mxd = d[i];
            b = i;
        }
    }
    go_down(a, b, 0);
    if (path.size() % 2 == 1) {
        cout << calc(path[path.size() / 2]) - 1 << endl;
    }
    else {
        cout << max(calc(path[path.size() / 2]), calc(path[path.size() / 2 - 1])) - 1 << endl;
    }
}
