#include <iostream>
#include <vector>
using namespace std;
using ll = long long;
ll dfs(const vector<vector<ll>>& graph, ll idx, ll par) {
    ll best = 0;
    for (ll i : graph[idx]) {
        if (par == i) {
            continue;
        }
        best = max(best, dfs(graph, i, idx));
    }
    return best + 1;
}
int main() {
    ios :: sync_with_stdio(false);
    cin.tie(nullptr);
    ll n, k;
    cin >> n >> k;
    vector<vector<ll>> graph(n + 1);
    for (ll i = 0; i < n - 1; i++) {
        ll u, v;
        cin >> u >> v;
        graph[u].push_back(v);
        graph[v].push_back(u);
    }
    ll best = 0;
    for (ll i = 1; i <= n; i++) {
        if (graph[i].size() == 1) {
            best = max(best, dfs(graph, i, -1));
        }
    }
    cout << best / 2;
}
