#include <bits/stdc++.h>
using namespace std;
#define int long long
#define endl '\n'

struct Point {
	int x;
	int d;
	int idx;
	
	friend bool operator <(Point a, Point b) {
		if (a.x != b.x) return a.x < b.x;
		if (a.idx == b.idx) return a.d > b.d;
		
		if (a.idx == 0) return a.d == 1;
		return b.d == -1;
	}
};

const int MAXQ = 2e5 + 10;
vector <Point> ev;
int ans[MAXQ];

void add(int l, int r) {
	ev.push_back({l, +1, 0});
	ev.push_back({r, -1, 0});
}

void solve() {
	int n, m; cin >> n >> m;
	int sum = 0;
	for (int i = 1; i <= n; i++) {
		int a, b; cin >> a >> b;
		sum += a / m; a = a % m;
		if (a == 0) continue;
		
		if (b + a - 1 <= m - 1) {
			add(b, b + a - 1);
			continue;
		}
		
		add(b, m - 1);
		a -= (m - b);
		add(0, a - 1);
	}
	
	int q; cin >> q;
	for (int i = 1; i <= q; i++) {
		int t; cin >> t;
		ev.push_back({t, 0, i});
	}
	
	sort(ev.begin(), ev.end());
	int cur = 0;
	for (auto i : ev) {
		cur += i.d;
		if (i.idx) ans[i.idx] = sum + cur;
	}
	
	for (int i = 1; i <= q; i++) cout << ans[i] << endl;
}

signed main () {
	ios::sync_with_stdio(false);
	cin.tie(nullptr);
	cout.tie(nullptr);
	
	solve();
}
