#include <bits/stdc++.h>

using namespace std;

vector<unordered_set<int>>graph;
void BFS(int src,int n)
{
    if(graph[src].size() >= n)
    {
        return;
    }
    queue<int> q;
    vector<bool>visited(n,false);
    q.push(src);
    while(!q.empty())
    {
        int curr = q.front();
        q.pop();
        if(visited[curr]) continue;
        visited[curr] = true;
        if(graph[curr].size()>=n) continue;
        for(int neigh : graph[curr])
        {
            if(!visited[neigh])
            {
                q.push(neigh);
                for(int p : graph[neigh])
                {
                    if(p != curr)
                    {
                        graph[curr].insert(p);
                    }
                }
            }
        }

    }
}

int main()
{
    int n;
    cin>>n;
    vector<pair<int,int>>players(n);
    graph.resize(n);
    for(int i=0; i<n; i++)
    {
        cin>>players[i].first>>players[i].second;
    }
    for(int i=0; i<n; i++)
    {
        for(int j=i+1; j<n; j++)
        {
            if(players[i].first >= players[j].first || players[i].second >= players[j].second)
            {
                graph[i].insert(j);
            }
            if(players[j].first >= players[i].first || players[j].second >= players[i].second)
            {
                graph[j].insert(i);
            }
        }
    }
    for(int i=0; i<n; i++)
    {
        BFS(i,n);
        if(graph[i].size()>=n-1)
        {
            cout<<'W';
        }
        else
        {
            cout<<'L';
        }
    }
    cout<<endl;
    /*for(int i=0;i<n;i++)
    {
        cout<<"Player "<<i<<endl;
        for(int p : graph[i])
        {
            cout<<p<<" ";
        }
        cout<<endl;
    }*/
    return 0;
}
