#include <bits/stdc++.h>

#define endl '\n'

using namespace std;

typedef long long llong;

const int MAXN = 5e3 + 10;
const int MAXM = 2 * MAXN;
const llong INF = 4e18 + 10;

struct Edge
{
    int u, v, cost;

    Edge(){};

    Edge(int u, int v, int cost)
    {
        this->u = u;
        this->v = v;
        this->cost = cost;
    }
};

int n, m;
llong dist[MAXN];
Edge edges[MAXM];
vector < int > adj[MAXN];
int visited[MAXN];
bool flag;

void read()
{
    cin >> n >> m;

    for(int i = 1; i <= m; i++)
    {
        cin >> edges[i].u >> edges[i].v >> edges[i].cost;

        edges[i].u++;
        edges[i].v++;
    }
}

void dfs(int u)
{
    visited[u] = 1;

    for(int v : adj[u])
    {
        if(visited[v] != 2)
        {
            flag = true;
        }

        if(visited[v] == 0)
        {
            dfs(v);
        }
    }

    visited[u] = 2;
}

void solve()
{
    for(int i = 1; i <= n - 1; i++)
    {
        for(int j = 1; j <= m; j++)
        {
            int u = edges[j].u;
            int v = edges[j].v;
            int cost = edges[j].cost;

            if(dist[u] + cost < dist[v])
            {
                dist[v] = dist[u] + cost;
            }
        }
    }

    bool lampa = false;

    for(int j = 1; j <= m; j++)
    {
        int u = edges[j].u;
        int v = edges[j].v;
        int cost = edges[j].cost;

        if(dist[u] + cost < dist[v])
        {
            lampa = true;
        }
        else if(dist[u] + cost == dist[v])
        {
            adj[u].push_back(v);
        }
    }

    if(lampa)
    {
        cout << 1 << endl;
        return;
    }

    for(int i = 1; i <= n; i++)
    {
        if(visited[i] == 0)
        {
            dfs(i);
        }
    }

    cout << flag << endl;
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);

    read();
    solve();

    return 0;
}
/**

6 7
0 1 3
0 2 -6
0 4 0
1 2 4
2 3 2
3 0 4
5 2 2

*/
