#include <bits/stdc++.h>

#define endl '\n'

using namespace std;

typedef long long llong;

const int MAXN = 5e3 + 10;
const int MAXM = 2 * MAXN;
const llong INF = 4e18 + 10;

struct Edge
{
    int u, v, cost;

    Edge(){};

    Edge(int u, int v, int cost)
    {
        this->u = u;
        this->v = v;
        this->cost = cost;
    }
};

int n, m;
Edge edges[MAXM];
llong dist[MAXN][MAXN];

void read()
{
    cin >> n >> m;

    for(int i = 1; i <= n; i++)
    {
        for(int j = 1; j <= n; j++)
        {
            dist[i][j] = INF;
        }

        dist[i][i] = 0;
    }

    for(int i = 1; i <= m; i++)
    {
        cin >> edges[i].u >> edges[i].v >> edges[i].cost;

        edges[i].u++;
        edges[i].v++;

        dist[edges[i].u][edges[i].v] = min(dist[edges[i].u][edges[i].v], (llong)edges[i].cost);
    }
}

void solve()
{
    for(int k = 1; k <= n; k++)
    {
        for(int i = 1; i <= n; i++)
        {
            for(int j = 1; j <= n; j++)
            {
                dist[i][j] = min(dist[i][j], dist[i][k] + dist[k][j]);
            }
        }
    }

    bool lampa = false;

    for(int i = 1; i <= n; i++)
    {
        for(int j = 1; j <= n; j++)
        {
            if(i == j)
                continue;

            if(dist[i][j] + dist[j][i] <= 0)
            {
                lampa = true;
            }
        }
    }

    cout << lampa << endl;
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);

    read();
    solve();

    return 0;
}
