#include <bits/stdc++.h>

#define endl '\n'

using namespace std;

typedef long long llong;

const int MAXN = 5e3 + 10;
const int MAXM = 2 * MAXN;
const llong INF = 4e18 + 10;

struct Edge
{
    int u, v, cost;

    Edge(){};

    Edge(int u, int v, int cost)
    {
        this->u = u;
        this->v = v;
        this->cost = cost;
    }
};

int n, m;
llong dist[MAXN];
Edge edges[MAXM];

void read()
{
    cin >> n >> m;

    for(int i = 1; i <= m; i++)
    {
        cin >> edges[i].u >> edges[i].v >> edges[i].cost;
    }
}

void solve()
{
    for(int i = 1; i <= n - 1; i++)
    {
        for(int j = 1; j <= m; j++)
        {
            int u = edges[j].u;
            int v = edges[j].v;
            int cost = edges[j].cost;

            if(dist[u] + cost < dist[v])
            {
                dist[v] = dist[u] + cost;
            }
        }
    }

    bool lampa = false;

    for(int j = 1; j <= m; j++)
    {
        int u = edges[j].u;
        int v = edges[j].v;
        int cost = edges[j].cost;

        if(dist[u] + cost < dist[v])
        {
            dist[v] = dist[u] + cost;
            lampa = true;
        }
    }

    cout << lampa << endl;
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);

    read();
    solve();

    return 0;
}
