#include <bits/stdc++.h>

#define endl '\n'

using namespace std;

typedef long long llong;

const int MAXN = 1e6 + 10;

struct Fighter
{
    int a, b, idx;

    Fighter(){};

    Fighter(int a, int b, int idx)
    {
        this->a = a;
        this->b = b;
        this->idx = idx;
    }
};

bool cmpa(Fighter f1, Fighter f2)
{
    if(f1.a != f2.a)
        return f1.a < f2.a;

    return f1.b < f2.b;
}

bool cmpb(Fighter f1, Fighter f2)
{
    if(f1.b != f2.b)
        return f1.b < f2.b;

    return f1.a < f2.a;
}

int n;
int a[MAXN], b[MAXN];
bool visited[MAXN];

Fighter bya[MAXN];
Fighter byb[MAXN];

int apos[MAXN];
int bpos[MAXN];

int la, lb;

void read()
{
    cin >> n;

    for(int i = 1; i <= n; i++)
    {
        cin >> a[i] >> b[i];

        bya[i] = byb[i] = Fighter(a[i], b[i], i);
    }
}

void update(int idx)
{
    visited[idx] = true;

    la = min(la, apos[idx]);
    lb = min(lb, bpos[idx]);
}

void solve()
{
    sort(bya + 1, bya + n + 1, cmpa);
    sort(byb + 1, byb + n + 1, cmpb);

    for(int i = 1; i <= n; i++)
    {
        apos[bya[i].idx] = i;
        bpos[byb[i].idx] = i;
    }

    la = n, lb = n;

    update(bya[n].idx);
    update(byb[n].idx);

    for(int i = n - 1; i >= 1; i--)
    {
        if(!visited[bya[i].idx])
        {
            if(visited[bya[i + 1].idx] && bya[i + 1].a == bya[i].a)
            {
                update(bya[i].idx);
            }
            else if(la <= i)
            {
                update(bya[i].idx);
            }
        }

        if(!visited[byb[i].idx])
        {
            if(visited[byb[i + 1].idx] && byb[i + 1].b == byb[i].b)
            {
                update(byb[i].idx);
            }
            else if(lb <= i)
            {
                update(byb[i].idx);
            }
        }

        if(!visited[bya[i].idx])
        {
            if(visited[bya[i + 1].idx] && bya[i + 1].a == bya[i].a)
            {
                update(bya[i].idx);
            }
            else if(la <= i)
            {
                update(bya[i].idx);
            }
        }

        if(!visited[byb[i].idx])
        {
            if(visited[byb[i + 1].idx] && byb[i + 1].b == byb[i].b)
            {
                update(byb[i].idx);
            }
            else if(lb <= i)
            {
                update(byb[i].idx);
            }
        }
    }

    for(int i = 1; i <= n; i++)
    {
        if(visited[i])
        {
            cout << "W";
        }
        else
        {
            cout << "L";
        }
    }
    cout << endl;
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);

    read();
    solve();

    return 0;
}
