#include <bits/stdc++.h>

#define endl '\n'

using namespace std;

typedef long long llong;

const int MAXN = 1e6 + 10;

int n;
int a[MAXN], b[MAXN];

vector < int > adj[MAXN];
bool visited[MAXN];

void read()
{
    cin >> n;

    for(int i = 1; i <= n; i++)
    {
        cin >> a[i] >> b[i];
    }
}

void build_graph()
{
    for(int i = 1; i <= n; i++)
    {
        for(int j = 1; j <= n; j++)
        {
            if(i == j)
                continue;

            if(a[i] >= a[j] || b[i] >= b[j])
            {
                adj[i].push_back(j);
            }
        }
    }
}

void dfs(int u)
{
    if(visited[u])
        return;

    visited[u] = true;

    for(int v : adj[u])
    {
        dfs(v);
    }
}

void solve()
{
    for(int i = 1; i <= n; i++)
    {
        for(int j = 1; j <= n; j++)
        {
            visited[j] = false;
        }

        dfs(i);

        bool lampa = true;

        for(int j = 1; j <= n; j++)
        {
            lampa &= visited[j];
        }

        if(lampa)
        {
            cout << "W";
        }
        else
        {
            cout << "L";
        }
    }
    cout << endl;
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);

    read();
    build_graph();
    solve();

    return 0;
}
