#include <bits/stdc++.h>
using namespace std;

const int MAXN = 5e3 + 10;
vector <tuple <int, int, long long>> edge_list;
long long t[MAXN];
//long long d[MAXN][MAXN];

bool relax() {
    bool f = 0;

    for (auto [u, v, cost] : edge_list) {
        if (t[v] > t[u] + cost) {
            t[v] = t[u] + cost;
            f = 1;
        }
    }
    
    return f;
}

int n, m;
vector <pair <int, int>> edges[MAXN];
bool v[MAXN];

bool spfa(int vertex) {
    fill(t, t + n, 1e18);
    priority_queue <pair <long long, int>, vector <pair <long long, int>>, greater <pair <long long, int>>> q;
    q.push(pair <long long, int> (0, vertex));

    while (q.size()) {
        auto [tt, u] = q.top();
        q.pop();

        if (u == vertex && t == 0) return 1;
        if (t[u] <= tt) continue;
        t[u] = tt;

        for (auto [x, d] : edges[u]) {
            if (v[x]) continue;

            if (t[x] > t[u] + d) {
                q.push(pair <long long, int> (t[u] + d, x));
            }
        }
    }

    v[vertex] = 1;
    return 0;
}

int main() {

    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);
    
    cin >> n >> m;

    while (m--) {
        int u, v, cost;
        cin >> u >> v >> cost;

        edge_list.push_back({u, v, cost});
        edges[u].push_back({v, cost});
    }

    fill(t, t + n, 1e18);
    t[0] = 0;
    
    for (int i = 1; i <= 2 * n; i++) {
        relax();
    }

    if (relax()) {
        cout << 1 << '\n';
        return 0;
    }

    for (int i = 0; i < n; i++) {
        if (spfa(i)) {
            cout << 1 << '\n';
            return 0;
        }
    }

    cout << 0 << '\n';

    return 0;

}