#include <bits/stdc++.h>
using namespace std;

const int MAXN = 1e4 + 10;
vector <tuple <int, int, long long>> edge_list;
vector <int> edges[MAXN], reverse_edges[MAXN];
long long t[MAXN], n, m;

stack <int> topological;
bool visited[MAXN];

void dfs(int u) {
    if (visited[u]) return;
    visited[u] = 1;
    
    for (int x : edges[u]) {
        dfs(x);
    }
    
    topological.push(u);
}

int component[MAXN], csz[MAXN];
bool vc[MAXN];

void component_dfs(int u, int comp) {
    if (component[u]) return;
    component[u] = comp;
    csz[comp]++;
    
    for (int x : reverse_edges[u]) {
        component_dfs(x, comp);
    }
}

bool relax(int comp) {
    bool f = 0;
    
    for (auto [u, v, cost] : edge_list) {
        if (component[v] != comp) continue;

        if (t[v] > t[u] + cost) {
            t[v] = t[u] + cost;
            f = 1;
        }
    }

    return f;
}

bool v[MAXN];
vector <pair <int, long long>> weighted[MAXN];

bool dfs_check(int u, int d) {
    v[u] = 1;

    bool ans = 0;

    for (auto [x, cost] : weighted[u]) {
        if (component[x] != component[u]) continue;
        if (v[x]) {
            
        } else ans = (ans || dfs_check(x, d));
    }

    return ans;
}

int main() {
    
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);
    
    cin >> n >> m;

    for (int i = 1; i <= m; i++) {
        int u, v, cost;
        cin >> u >> v >> cost;

        edges[u].push_back(v);
        reverse_edges[v].push_back(u);
        weighted[u].push_back({v, cost});
        edge_list.push_back({u, v, cost});
    }

    for (int i = 0; i < n; i++) {
        dfs(i);
    }

    int cnt = 0;

    while (topological.size()) {
        int i = topological.top();
        topological.pop();
        if (component[i]) continue;
        component_dfs(i, ++cnt);
    }

    bool f = 0;

    for (int i = 0; i < n; i++) {
        if (vc[component[i]]) continue;
        vc[component[i]] = 1;

        fill(t, t + n, 1e18);
        t[i] = 0;
        
        for (int j = 1; j < csz[component[i]]; j++) {
            relax(component[i]);
        }

        if (relax(component[i])) {
            f = 1;
            break;
        }
    }

    cout << f << '\n';
    
    return 0;

}

/**
6 7
0 1 -3
0 2 -5
0 4 0
1 2 -4
2 3 2
3 0 4
5 2 2

6 7
0 1 -1
0 2 -2
0 4 1
1 2 3
2 3 -3
3 0 6
5 2 -1
 */