#include <bits/stdc++.h>
using namespace std;

const int MAXN = 1e4 + 10;
vector <tuple <int, int, long long>> edge_list;
long long t[MAXN], n, m;

bool relax() {
    bool f = 0;
    
    for (auto [u, v, cost] : edge_list) {
        if (t[v] > t[u] + cost) {
            t[v] = t[u] + cost;
            f = 1;
        }
    }

    return f;
}

int main() {

    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);

    cin >> n >> m;

    for (int i = 1; i <= m; i++) {
        int u, v, cost;
        cin >> u >> v >> cost;

        edge_list.push_back({u, v, cost});
    }

    bool f = 0;

    for (int i = 0; i < n; i++) {
        fill(t, t + n, 1e18);
        t[i] = 0;
        
        for (int j = 1; j < n; j++) {
            relax();
        }

        if (relax()) {
            f = 1;
            break;
        }

        for (auto [u, v, cost] : edge_list) {
            if (v == i && t[u] + cost == t[v]) {
                f = 1;
                break;
            }
        }

        if (f) break;
    }

    cout << f << '\n';
    
    return 0;

}

/**
6 7
0 1 -3
0 2 -5
0 4 0
1 2 -4
2 3 2
3 0 4
5 2 2

6 7
0 1 -1
0 2 -2
0 4 1
1 2 3
2 3 -3
3 0 6
5 2 -1
 */